<?php
/**
 * Hook when we are activating plugin
 * @return never
 */
///////////////////////////////////////// PROPERTY POSTS
function wp_sas_property_posts_create_database_table(): void {
	global $wpdb;
	$table_name      = $wpdb->prefix . 'sas_property_posts';
	$charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        post_id INTEGER DEFAULT '0' NOT NULL,
        wp_post_id INTEGER DEFAULT '0' NOT NULL
    ) $charset_collate;";

	require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	dbDelta( $sql );
}

/**
 * Hook when we are uninstalling plugin
 * @return never
 */
function wp_sas_property_posts_delete_database_table(): void {
    global $wpdb;

    $table_name = $wpdb->prefix . 'sas_property_posts';

    $wpdb->query( "DROP TABLE IF EXISTS $table_name" );
}

///////////////////////////////////////// SITEMAP FILES
function wp_sas_sitemap_files_create_database_table(): void {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sas_sitemap_files';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        path VARCHAR(200) DEFAULT '' NOT NULL
    ) $charset_collate;";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta( $sql );
}

function wp_sas_sitemap_files_autoupdate_database_table_exists(): void {
    if(!wp_sas_sitemap_files_check_database_table_exists()){
        wp_sas_sitemap_files_create_database_table();
    }
}

function wp_sas_sitemap_files_check_database_table_exists(): bool {
    global $wpdb;
    $table_name = $wpdb->prefix . 'sas_sitemap_files';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "SHOW TABLES LIKE '$table_name';";

    return $wpdb->query( $sql );;
}

/**
 * Hook when we are uninstalling plugin
 * @return never
 */
function wp_sas_sitemap_files_delete_database_table(): void {
    global $wpdb;

    $table_name = $wpdb->prefix . 'sas_sitemap_files';

    $wpdb->query( "DROP TABLE IF EXISTS $table_name" );
}
register_activation_hook( SAS_MAIN_FILE_PATH, 'wp_sas_property_posts_create_database_table');
register_activation_hook( SAS_MAIN_FILE_PATH, 'wp_sas_sitemap_files_create_database_table');
//register_uninstall_hook( SAS_MAIN_FILE_PATH, 'wp_sas_property_posts_delete_database_table');
