<?php

namespace Saswp\DTOs\Response;

class PropertyHouseConfigurationDTO
{
    public readonly int $id;
    public readonly string $name;
    public readonly string $room_type_name;
    public readonly array $room_type_amenities;
    public readonly int $order;

    public function __construct(array $_data)
    {
        $this->id  = isset($_data['id']) ?$_data['id']:0;
        $this->name  = isset($_data['name']) ?$_data['name']:'';
        $this->room_type_name  = isset($_data['room_type']['name']) ?$_data['room_type']['name']:'';
        $this->order  = isset($_data['order']) ?$_data['order']:0;
        $this->parseAmenities($_data);
    }

    public function parseAmenities(array $_data){
        $_room_type_amenities = [];
        foreach($_data['room_type']['amenities'] as $amenity){
            $_room_type_amenities[] = new PropertyAmenityDTO($amenity);
        }
        $this->room_type_amenities = $_room_type_amenities;
    }

    public function toArray(): array
    {
        return (array)$this;
    }
    
}
