<?php

namespace Saswp\DTOs;

class SasSettingsDTO
{

    public readonly string $sas_api_url;
    public readonly int $sas_api_url_https;
    public readonly string $sas_api_token;
    public readonly string $sas_route_vendor_property_main_featured;
    public readonly string $sas_guest_panel_route;
    public readonly int $sas_one_property_page_id;
    public readonly int $sas_one_property_page_flag;
    public readonly int $sas_post_update_flag;
    public readonly int $sas_version_save;
    public readonly string $property_name_filter;

    public function __construct(array $_data)
    {
        $this->parseApiUrl($_data);
        $this->sas_api_token  = isset($_data['sas_api_token']) ?$_data['sas_api_token']:'';
        $this->sas_route_vendor_property_main_featured  = isset($_data['sas_route_vendor_property_main_featured']) ?$_data['sas_route_vendor_property_main_featured']:'';
        $this->sas_guest_panel_route  = isset($_data['sas_guest_panel_route']) ?$_data['sas_guest_panel_route']:'';
        $this->sas_one_property_page_id  = (int) isset($_data['sas_one_property_page_id']) && is_numeric($_data['sas_one_property_page_id']) ?$_data['sas_one_property_page_id']:0;
        $this->sas_one_property_page_flag  = isset($_data['sas_one_property_page_flag']) ?$_data['sas_one_property_page_flag']:0;
        $this->sas_post_update_flag  = isset($_data['sas_post_update_flag']) ?$_data['sas_post_update_flag']:0;
        $this->sas_version_save  = isset($_data['sas_version_save']) ?$_data['sas_version_save']:0;
        $this->property_name_filter  = isset($_data['property_name_filter']) ?$_data['property_name_filter']:'';
    }

    public function parseApiUrl(array $_data){
        $this->sas_api_url_https  = isset($_data['sas_api_url_https']) ?$_data['sas_api_url_https']:0;
        // Force url format http://host.com
        if (isset($_data['sas_api_url'])) {
            $url = wp_parse_url($_data['sas_api_url']);
            $scheme = "http";
            if($this->sas_api_url_https){ $scheme = "https";}
            $_data['sas_api_url'] = "{$scheme}://{$url['host']}";
            if (isset($url['port'])) {
                $_data['sas_api_url'] .= ":{$url['port']}";
            }
        }
        $this->sas_api_url  = isset($_data['sas_api_url']) ?$_data['sas_api_url']:'';
    }

    public function toArray(): array
    {
        return (array)$this;
    }
}
