<?php
// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage

namespace Saswp;

function property_image_shortcode() {
	$settings       = new \Saswp\Settings();
	$property       = new \Saswp\Repository\PropertyRepository();
	$propertyDTO    = $property->get( $settings->get( 'sas_one_property_page_id' ) )->getProperty();
	$propertyImages = $property->get( $settings->get( 'sas_one_property_page_id' ) )->getPropertyImages();

	if ( $propertyImages ) {
		$carousel_items = '';
		foreach ( $propertyImages as $index => $image ) {
			$active_class   = $index === 0 ? 'active' : '';
			$carousel_items .= '
                <div class="carousel-item ' . $active_class . '">
                    <img src="' . esc_url($image->full_path_large) . '" class="d-block w-100" alt="' . esc_attr($propertyDTO->name) . '">
                </div>';
		}

		return '
            <div id="propertyCarousel" class="carousel slide ratio ratio-4x3" data-bs-ride="carousel">
                <div class="carousel-inner">
                    ' . $carousel_items . '
                </div>
				<div>
					<button class="carousel-control-prev" type="button" data-bs-target="#propertyCarousel" data-bs-slide="prev">
						<i class="fas fa-chevron-left"  aria-hidden="true"></i>
						<span class="visually-hidden">Previous</span>
					</button>
					<button class="carousel-control-next" type="button" data-bs-target="#propertyCarousel" data-bs-slide="next">
						<i class="fas fa-chevron-right"></i>
						<span class="visually-hidden">Next</span>
					</button>
				</div>
            </div>';
	} else {
		return '<div class="property-image" data-shortcode="property_image"></div>';
	}
}

?>
