jQuery(document).ready(function ($) {
	$("[data-shortcode]").each(function () {
		var shortcode = $(this).data("shortcode");
		var $element = $(this);
		$.ajax({
			url: sas_ajax_obj.ajax_url,
			type: "POST",
			data: {
				action: "sas_api_get_content",
				shortcode: shortcode,
			},
			success: function (response) {
				if (response.success && response.data[shortcode]) {
					$element.html(response.data[shortcode]);
				} else {
					console.log("No data found for shortcode:", shortcode);
					$element.html(
						"<div>No data found for this shortcode</div>",
					);
				}
			},
			error: function (xhr, status, error) {
				console.log("AJAX Error:", error);
				$element.html(
					"<div>Failed to fetch data for this shortcode</div>",
				);
			},
		});
	});
});
