<?php
// Adiciona uma página de configurações ao menu de administração
add_action('admin_menu', function () {
    add_menu_page('Search and Stay', 'Search and Stay', 'manage_options', 'saswp-plugin', function () {
    }, 'dashicons-palmtree', 100);

    add_submenu_page('saswp-plugin', 'Shortcodes', 'Shortcodes', 'manage_options', 'saswp-shortcodes', function () {
        include SASWP_DIR . '/pages/admin/shortcodes.php';
    });

        add_submenu_page('saswp-plugin', 'Sitemap files', 'Sitemap Files', 'manage_options', 'saswp-sitemap-files', function () {
        include SASWP_DIR . '/pages/admin/sitemap_files.php';
    });

    remove_submenu_page('saswp-plugin', 'saswp-plugin');
});

// Plugin mode
if ('pages' == pathinfo(dirname(__DIR__), PATHINFO_BASENAME)) {
    $GLOBALS['saswp']['plugin'] = true;
    $GLOBALS['saswp']['url'] = plugins_url('', __FILE__);

    add_action('admin_menu', function () {
        add_submenu_page('saswp-plugin', 'Plugin Settings', 'Plugin Settings', 'manage_options', 'saswp-plugin-settings', function () {
            include SASWP_DIR . '/pages/admin/plugin-settings.php';
        });
    });
}

// Função para renderizar a página de administração
function sas_plugin_pagina()
{
    $file_path = plugin_dir_path(__FILE__) . 'page-templates/admin.php';
    if (file_exists($file_path)) {
        include $file_path;
    } else {
        echo '<div class="error"><p>O arquivo de template não foi encontrado: ' . esc_html($file_path) . '</p></div>';
    }
}