<div class="wrap">
	<h1>Plugin Settings</h1>
	<form id="sas-wp-settings" method="post" action="<?php echo esc_url( \Saswp\Api::url( '/settings/save' ) ); ?>">
		<?php
		// Adiciona o nonce para segurança
		wp_nonce_field( 'meu_plugin_settings_save', 'meu_plugin_nonce' );
		$settings = new Saswp\Settings();
		$_data    = $settings->all()['data'];
		?>
		<table class="form-table">
			<tr>
				<th colspan="2">
					<div id="box_response" class="alert " style="display: hidden"></div>
				</th>
			</tr>
			<tr>
				<th scope="row">
					<label for="sas_api_url">API URL</label>
				</th>
				<td>
					<input name="settings[sas_api_url]" type="text" id="sas_api_url"
						   value="<?php echo esc_attr( $_data['sas_api_url'] ); ?>" class="regular-text">
					Https?
					<input name="settings[sas_api_url_https]" type="checkbox" id="sas_api_url_https"
						   value="1" <?php if ( $_data['sas_api_url_https'] ) {
						echo "checked=checked";
					} ?> class="regular-text">
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="sas_api_token">Token</label>
				</th>
				<td>
					<input name="settings[sas_api_token]" type="text" id="sas_api_token"
						   value="<?php echo esc_attr( $_data['sas_api_token'] ); ?>" class="regular-text">
				</td>
			</tr>
<!--			 <tr>-->
<!--                <th scope="row">-->
<!--                    <label for="sas_api_property_url">"Vendor property main featured" page URL</label>-->
<!--                </th>-->
<!--                <td>-->
<!--                    <input name="settings[sas_route_vendor_property_main_featured]" type="text" id="sas_api_property_url" value="--><?php //echo esc_attr( $_data['sas_route_vendor_property_main_featured'] ); ?><!--" class="regular-text">-->
<!--                    --><?php //if ( $settings->getSasSettingsDTO()->sas_api_url != "" ) { ?>
<!--                        <i>E.g.: <span id="vendor_property_page_url">--><?php //= $settings->retrieveVendorPropertyPageUrl() ?><!--</span></i>-->
<!--                    --><?php //} ?>
<!--                </td>-->
<!--            </tr>-->
<!--            <tr>-->
<!--                <th scope="row">-->
<!--                    <label for="sas_api_guest_url">"Guest" page URL</label>-->
<!--                </th>-->
<!--                <td>-->
<!--                    <input name="settings[sas_guest_panel_route]" type="text" id="sas_api_guest_url" value="--><?php //echo esc_attr( $_data['sas_guest_panel_route'] ); ?><!--" class="regular-text">-->
<!--                    --><?php //if ( $settings->getSasSettingsDTO()->sas_api_url != "" ) { ?>
<!--                        <i>E.g.: <span id="guest_page_url">--><?php //= $settings->retrieveGuestPageUrl() ?><!--</span></i>-->
<!--                    --><?php //} ?>
<!--                </td>-->
<!--            </tr>-->
			<tr>
				<th scope="row">
					<label for="sas_post_update_flag">Allow property post updates?</label>
				</th>
				<td>
					<input name="settings[sas_post_update_flag]" type="checkbox" id="sas_post_update_flag"
						   value="1" <?php if ( $_data['sas_post_update_flag'] == 1 ) {
						echo "checked";
					} ?> class="regular-text">
					<i>With this option enabled, then the plugin will retrieve posts based on the configured
						properties.</span></i>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="sas_one_property_page_flag">Only one property page site</label>
				</th>
				<td>
					<input name="settings[sas_one_property_page_flag]" type="checkbox" id="sas_one_property_page_flag"
						   value="1" <?php if ( ( $_data['sas_one_property_page_flag'] ?? 0 ) == 1 ) {
						echo "checked=checked";
					} ?> class="regular-text">
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="sas_one_property_page_id">Which property should be used as one page?</label>
				</th>
				<td>
					<div style="max-width: 400px" id="single-property-selection">
						<single-property-selection/>
					</div>
					<input
						type="hidden"
						name="settings[sas_one_property_page_id]"
						id="sas_one_property_page_id"
						value="<?php esc_attr($_data['sas_one_property_page_id']) ?>"
					/>
					<!--										                    <input type="text" name="property_filter_name" id="property_filter_name" value="" />-->
					<!--					                    <select id="property_select">-->
					<!--					                        <option value="">No property selected</option>-->
					<!--					                        --><?php
					//					                            foreach($settings->getPropertyList() ?? [] as $property){
					//					                                ?>
					<!--					                                    <option value="-->
					<!--					--><?php //=$property['properties']['id']?><!--"-->
					<!--					                                        --><?php //if($_data['sas_one_property_page_id'] == $property['properties']['id']) echo "selected=selected"; ?>
					<!--					                                    >-->
					<!--					--><?php //=$property['properties']['name']?><!--</option>-->
					<!--					                                --><?php
					//					                            }
					//
					//					                        ?>
					<!--					                    </select>-->
				</td>
			</tr>
		</table>
		<p>
			<strong style="font-size: 14px;">/property and /user are set by default and cannot be changed.</strong>
		</p>
		<p class="submit">
			<input type="button" class="button-save button button-primary" value="Save changes">
		</p>

		<!--        <p class="button">-->
		<!--            <input type="button" class=" button button-load-property button-primary" value="Load Properties">-->
		<!--        </p>-->
	</form>
</div>
<script>
	jQuery(document).ready(function ($) {
		$("#property_select").on('change', function () {
			jQuery('#sas_one_property_page_id').val($(this).find(":selected").val());
		});
		$("#sas-wp-settings .button-save").on('click', function () {
			$("#box_response")
				.removeClass("alert-danger, alert-success")
				.html('').hide();

			var form = $("#sas-wp-settings");
			$.ajax({
				url: form.attr('action'),
				type: 'POST',
				data: form.serialize(),
				success: function (response) {
					if (response.success) {
						var text = "Data updated successfully";
						$("#box_response")
							.addClass("alert-success")
							.html(text).show();
						$("#sas_api_url").val(response.data.sas_api_url);
						$("#vendor_property_page_url").html(response.data.vendor_property_page_url);
						$("#guest_page_url").html(response.data.guest_page_url);
						$("#sas_one_property_page_id").val(response.data.sas_one_property_page_id);
					} else {
						var text = "Failed to update data. Please check fields and try again.";
						$("#box_response")
							.addClass("alert-danger")
							.html(text).show();
					}
				},
				error: function (xhr, status, error) {
					console.log('AJAX Error:', error);
					$element.html('<div>Failed to fetch data for this shortcode</div>');
				}
			});
			return false;
		});
	});

	function refreshPropertyList(data) {
		var propertySelected = jQuery("#sas_one_property_page_id").val();
		var select = jQuery('#property_select');
		select.find('option:not(:first)')
			.remove();
		var selectedIndex = 0;
		var properties = data.properties;
		for (let i = 0; i < properties.length; i++) {
			select
				.append('<option value="' + properties[i]['properties']['id'] + '">' + properties[i]['properties']['name'] + '</option>')
				.val('whatever');
			if (propertySelected == properties[i]['properties']['id']) {
				selectedIndex = i + 1;
			}
		}
		select.prop("selectedIndex", selectedIndex);

	}
</script>
