<?php 
// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
?>

<style>
.tooltip-container {
    position: relative;
    display: inline-block;
}

.tooltip-container .tooltip-text {
    visibility: hidden;
    width: 250px;
    background-color: #333;
    color: #fff;
    text-align: center;
    border-radius: 4px;
    padding: 5px;
    position: absolute;
    z-index: 1;
    bottom: 125%;
    left: 50%;
    transform: translateX(-50%);
    opacity: 0;
    transition: opacity 0.3s;
}

.tooltip-container:hover .tooltip-text {
    visibility: visible;
    opacity: 1;
}
</style>

<div class="wrap">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Shortcodes</h1>
        <img width="250" src="<?php echo esc_url(SAS_URL) . 'assets/images/logo-sas.png'; ?>" alt="Logo Search and Stay">
    </div>

    <div class="p-4 rounded-md mb-6">
        <p>Available shortcodes:</p>
	</div>

    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
		<?php
		global $sas_shortcodes;

		$sas_shortcodes_descriptions = [
			'[sas_logo]' => 'Displays the custom website logo that has been configured within the Search and Stay admin panel. This ensures brand consistency across the site.',
			'[property_title]' => 'Displays the main title or name of the property.',
			'[property_description]' => 'Displays the full-length description of the property.',
			'[property_image]' => 'Renders an image carousel or gallery for the property, allowing users to browse through all available photos.',
			'[property_basic_information]' => "Outputs a summary of the property's essential details, such as availability.",
			'[property_house_configuration]' => "Outputs a summary of the property's essential details, such as the number of bedrooms, bathrooms, and guest capacity.",
			'[property_amenities]' => 'Lists all the amenities available at the property (e.g., Wi-Fi, swimming pool, air conditioning).',
			'[property_price]' => 'Shows the current pricing information for the property. This includes the nightly rate.',
			'[property_rating]' => "Displays the property's average user rating.",
			'[property_address]' => 'Displays the full address of the property.',
			'[property_pid]' => 'Outputs the unique Property ID (PID). This is often used for internal reference or advanced integrations.',
			'[single_property_selection]' => 'Displays the primary property selection interface. This is a crucial component for the single property view, often including the booking widget and primary details.',
			'[property_maps_all]' => 'Displays a map with markers for all available properties. This provides a comprehensive geographical overview of your listings.',
			'[property_maps_load]' => 'Embeds an interactive map that dynamically loads property markers as the user pans and zooms. This enhances performance for sites with a large number of listings.',
			'[property_list_view_port]' => 'Displays a list of properties within a defined viewport. This is particularly useful for embedding a selection of properties within a blog post or a promotional landing page.',
			'[property_house_rules]' => 'Displays the specific house rules that guests must adhere to.',
			'[property_holiday_types]' => 'Shows the "Holiday Types" associated with the property (e.g., Beach, Ski, Urban).',
			'[property_holiday_suitable]' => 'Lists the suitability of the property for different holiday styles or groups (e.g., Family-friendly, Romantic getaway).',
			'[property_availability]' => "Displays the property's availability calendar, showing booked and available dates.",
			'[saswp-property-search-form]' => 'Renders a powerful property search form featuring an autocomplete address field. This allows users to search for any location, providing maximum flexibility.',
			'[saswp-property-search-form-location]' => "Generates a property search form that uses a dropdown menu for location selection. This dropdown is dynamically populated only with locations that have available properties, ensuring users don't encounter empty search results.",
			'[banner_single]' => "Creates a visually appealing banner using the first five images from the property's gallery.",
			'[banner_multi]' => 'Banner with the first 5 images of the first 5 properties - Multi Property Theme',
			'[search_single]' => 'Search for check-in, check-out, guests, and pets for the property - Single Property Theme',
			'[saswp-theme-home-discover]' => 'Property listing based on the token',
			'[searchandstay_accessibility_filter]' => 'Filter for searching accessible accommodations',
			'[searchandstay_sustainability_filter]' => 'Filter for searching sustainable accommodations',
			'[searchandstay_pets_filter]' => 'Filter for searching accommodations with pets',
			'[searchandstay_pools_filter]' => 'Filter for searching accommodations with pools',
			'[searchandstay_houses_linen_filter]' => 'Filter for searching accommodations with linen',
			'[searchandstay_waterfront_filter]' => 'Filter for searching waterfront accommodations',
			'[searchandstay_beachfront_filter]' => 'Filter for searching beachfront accommodations',
			'[searchandstay_unique_accommodations_filter]' => 'Filter for searching unique accommodations',
			'[searchandstay_ski_filter]' => 'Filter for searching accommodations for sking',
			'[searchandstay_dedicated_workspace_filter]' => 'Filter for searching accommodations with dedicated workspace',
			'[searchandstay_list_of_filters]' => 'Sorted list of all filters',
		];

		if (!empty($sas_shortcodes)) {
			foreach ($sas_shortcodes as $shortcode) {
				echo '
				<div class="flex items-center justify-between bg-gray-100 p-3 my-1">
					<code class="text-sm font-mono">[' . esc_html($shortcode) . ']</code>
					<div class="tooltip-container">
						<span class="dashicons dashicons-editor-help text-md text-gray-500 cursor-help"></span>
						<span class="tooltip-text">' . esc_attr($sas_shortcodes_descriptions['[' . esc_html($shortcode) . ']']) . '</span>
					</div>
					<button class="copy-btn text-black px-3 py-1 rounded-md text-sm" onclick="copyShortcode(this)">
						Copy
					</button>
				</div>';
			}
		} else {
			echo '<p class="text-gray-500">No shortcodes registered.</p>';
		}
		?>
	</div>

	<p class="mt-6 text-gray-600">Insert the above shortcodes in your posts or pages to display the content.</p>
</div>

<script>
    function copyShortcode(button) {
		const parent = button.parentElement;
		const codeElement = parent.querySelector('code.text-sm.font-mono');
		const shortcode = codeElement.textContent.trim();

        navigator.clipboard.writeText(shortcode).then(() => {
            button.textContent = "Copied!";
            setTimeout(() => button.textContent = "Copy", 1500);
        }).catch(err => console.error("Error on copy:", err));
    }
</script>
