<div class="wrap">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Sitemap Files</h1>
        <img width="250" src="<?php echo SAS_URL . 'assets/images/logo-sas.png'; ?>" alt="Logotipo Search and Stay">
    </div>

    <div class="p-4 rounded-md mb-6">
        <p>Sitemap files currently stored</p>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
            <?php
            global $sas_shortcodes;
            wp_sas_sitemap_files_autoupdate_database_table_exists();
            $vendorGroupWordpressSitemapDownloadApi = new \Saswp\Api\Vendor\VendorGroup\VendorGroupWordpressSitemapDownloadApi();
            $_files = $vendorGroupWordpressSitemapDownloadApi->retrieveWpSasSitemapFiles();

            $uploadDir =  wp_upload_dir();
            if (count($_files)) {
                foreach ($_files as $file) {
                    $fullUrl = ($uploadDir['baseurl']??'') . $file->path;
                    echo '
                    <div class="flex items-center justify-between bg-gray-100 p-3 my-1">
                        <code class="text-sm font-mono">[<a href="'.$fullUrl.'" target="_blank">' . $fullUrl . '</a>]</code>
                    </div>';
                }
            } else {
                echo '<p class="text-gray-500">There aren\'t files registered.</p>';
            }
            ?>
        </div>

        <div class="mt-5">
            <button href="#" class="button button-primary sync-xml">Update Sitemap</button>
        </div>

    </div>

    <script>
        jQuery(document).ready(function() {
            jQuery(".sync-xml").on("click", function() {
                let el = jQuery(this)
                
                el.html('<span class="dashicons dashicons-update spin mt-1"></span> Updating Sitemap...')
                el.prop("disabled", true)
                
                jQuery.ajax({
                    url: "<?php echo get_site_url(); ?>/wp-json/saswp/public/trigger_sitemap_download",
                }).success(function() {
                    el.html('<span class="dashicons dashicons-yes mt-1"></span> Complete')
                }).done(function() {
                    setTimeout(function() {
                        el.html('Update Sitemap')
                        el.prop("disabled", false)
                    }, 1500)
                })
            })
        })
    </script>

    <style scoped>
        .spin {
            -webkit-animation:spin 1s linear infinite;
            -moz-animation:spin 1s linear infinite;
            animation:spin 1s linear infinite;
        }
        @-moz-keyframes spin { 
            100% { -moz-transform: rotate(360deg); } 
        }
        @-webkit-keyframes spin { 
            100% { -webkit-transform: rotate(360deg); } 
        }
        @keyframes spin { 
        100% { 
            -webkit-transform: rotate(360deg); 
            transform:rotate(360deg); 
        } 
    }
    </style>