<?php

if (!defined('ABSPATH')) {
	exit;
}

define('SASWP_DIR', __DIR__);
define('SAS_URL', plugin_dir_url(__FILE__));
define('SAS_WP', plugin_dir_path(__FILE__) . 'saswp/');
define('SAS_INC', plugin_dir_path(__FILE__) . 'inc/');
define('SAS_INC_DTO', SAS_INC . 'DTOs/');
define('BOOTSTRAP_CSS', plugins_url('vendor/bootstrap/dist/css/', __FILE__));
define('BOOTSTRAP_JS', plugins_url('vendor/bootstrap/dist/js/', __FILE__));
define('SASWP_CSS', plugins_url('vendor/saswp/dist/css/', __FILE__));
define('SASWP_JS', plugins_url('vendor/saswp/dist/js/', __FILE__));

// Aumenta o tempo limite de requisição
add_filter('http_request_timeout', function () {
	return 10; // tempo limite de 10 segundos
});

$_fileDependencies = [
	SAS_INC . 'sas-api.php',
	SAS_INC . 'sas-style.php',
	SAS_WP . 'Api.php',
	SAS_WP . 'Settings.php',
	SAS_WP . 'Repository/PropertyRepository.php',
	SAS_INC . 'sas-shortcodes.php',
	SAS_INC_DTO . 'SasSettingsDTO.php',
	SAS_INC_DTO . 'Response/PropertyAmenityDTO.php',
	SAS_INC_DTO . 'Response/PropertyBasicInformationDTO.php',
	SAS_INC_DTO . 'Response/PropertyConfigurationDTO.php',
	SAS_INC_DTO . 'Response/PropertyDescriptionDTO.php',
	SAS_INC_DTO . 'Response/PropertyHouseConfigurationDTO.php',
	SAS_INC_DTO . 'Response/PropertyHouseRuleDTO.php',
	SAS_INC_DTO . 'Response/PropertyImageDTO.php',
	SAS_INC_DTO . 'Response/PropertyListDTO.php',
	SAS_INC_DTO . 'Response/PropertyDTO.php',
	SAS_INC_DTO . 'Response/PropertyLocationDTO.php',
	SAS_INC_DTO . 'Response/PropertyPricingDTO.php',
	SAS_INC_DTO . 'Response/PropertyRestrictionDTO.php',
	SAS_INC_DTO . 'Response/PropertyTypeDTO.php',
	SAS_INC_DTO . 'Response/Vendor/LoginJsonDTO.php',
	SAS_INC_DTO . 'Response/Vendor/ShowLeanFullDTO.php',
];

foreach ($_fileDependencies as $dependency) {
	if (file_exists($dependency)) {
		require_once($dependency);
	}
}
?>
