<?php

use Saswp\Repository\PropertyRepository;
use Saswp\Settings;

class SAS_Plugin {
	public static function init() {
		// function add_rewrite_rules( $wp_rewrite )
		// {

		// 	$section_rules = array(
		// 		'^property/(.+?)/(.+?)' => 'property-details.php?post_type=post&name='. $wp_rewrite->preg_index(1),
		// 	);

		// 	$wp_rewrite->rules = $section_rules + $wp_rewrite->rules;
		// }
		// add_action('generate_rewrite_rules', 'add_rewrite_rules');


		// Adiciona ações e filtros do WordPress
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );

		// Hook the function to the admin_notices action
    	//add_action( 'admin_notices', array( __CLASS__, 'noticeAfterXMLUpdate' ) );

		// Inicializa a API
		self::init_api();

		// Inicializa os shortcodes
		self::init_shortcodes();

		// add_action('wp_ajax_sas_api_get_content', array(__CLASS__, 'handle_api_get_content'));
		// add_action('wp_ajax_nopriv_sas_api_get_content', array(__CLASS__, 'handle_api_get_content'));
	}

	// public static function noticeAfterXMLUpdate() {
    //     echo '<div class="notice notice-success is-dismissible">';
    //         echo '<p>'. _e( 'Search and Stay: Sitemap XML updated successfully.' ) . '</p>';
    //     echo '</div>';
    // }


	public static function enqueue_scripts() {
		$version_plugin = '1.4.15';

		// phpcs:disable PluginCheck.CodeAnalysis.EnqueuedResourceOffloading.OffloadedContent
		wp_enqueue_style( 'vuetify', 'https://cdn.jsdelivr.net/npm/vuetify@3.6.0/dist/vuetify.min.css', array(), '3.6.0' );
		wp_enqueue_style( 'swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css', array(), '11.0.0' );
		wp_enqueue_style( 'mdi', 'https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css', array(), '7.4.47' );
		wp_enqueue_style( 'app', SAS_URL . 'src/assets/app.css', array(), '1.0.0' );
		wp_enqueue_style( 'sas-icons', SAS_URL . 'src/assets/sasicons.css', array( 'app' ), $version_plugin );
		wp_enqueue_style( 'calendar', SAS_URL . 'src/assets/calendar.css', array(), $version_plugin );
		wp_enqueue_style( 'leaflet-css', 'https://unpkg.com/leaflet@1.9.3/dist/leaflet.css', array(), '1.9.4', 'all' );
		wp_enqueue_script('font-awesome', 'https://kit.fontawesome.com/bbe1ff8639.js', [], '6.7.2', true);

		wp_enqueue_script( 'moment', 'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', array(), '2.29.1', true );
		wp_enqueue_script( 'swiper-js', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', array(), '11.0.0', true );
		wp_enqueue_script( 'vue-cdn', 'https://unpkg.com/vue@3.5.13', array( 'moment' ), '3.5.13', true );
		wp_enqueue_script( 'vue-3-sfc-loader', 'https://cdn.jsdelivr.net/npm/vue3-sfc-loader@0.9.5/dist/vue3-sfc-loader.js', array( 'vue-cdn' ), '0.9.5', true );
		wp_enqueue_script( 'imask', 'https://cdnjs.cloudflare.com/ajax/libs/imask/7.6.1/imask.min.js', array( 'vue-cdn' ), '7.6.1', true );
		wp_enqueue_script( 'vue-router', 'https://unpkg.com/vue-router@4.0.15/dist/vue-router.global.js', array( 'vue-cdn' ), '4.0.15', true );
		wp_enqueue_script( 'vuetify-js', 'https://cdn.jsdelivr.net/npm/vuetify@3.7.4/dist/vuetify.min.js', array( 'vue-cdn' ), '3.7.4', true );
		wp_enqueue_script( 'lodash', 'https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js', array( 'vue-cdn' ), '4.17.21', true );
		wp_enqueue_script( 'iconify', 'https://code.iconify.design/3/3.1.0/iconify.min.js', array( 'vuetify' ), '3.1.0', true );
		wp_enqueue_script( 'vue-demi', 'https://unpkg.com/vue-demi', array( 'vue-cdn' ), '0.14.6', true );
		wp_enqueue_script( 'pinia', 'https://unpkg.com/pinia@2.3.1', array( 'vue-cdn' ), '2.3.1', true );
		wp_enqueue_script( 'vue-core', 'https://unpkg.com/@vueuse/core', array( 'vue-cdn' ), '10.7.0', true );
		wp_enqueue_script( 'vuelidate', 'https://cdn.jsdelivr.net/npm/@vuelidate/core', array( 'vue-cdn' ), '2.1.0', true );
		wp_enqueue_script( 'vuelidate-validators', 'https://cdn.jsdelivr.net/npm/@vuelidate/validators', array( 'vuelidate' ), '2.1.0', true );
		wp_enqueue_script( 'recaptcha', 'https://www.google.com/recaptcha/api.js?render=6LeKQNwZAAAAAIyA1es6Dg0X_uC2qXjWjOC53I4D', array(), '3.0.0', true );
		wp_enqueue_script( 'axios-cdn', 'https://cdn.jsdelivr.net/npm/axios@1.7.9/dist/axios.min.js', array( 'vue-cdn' ), '1.7.9', true );
		wp_enqueue_script( 'stripe', 'https://js.stripe.com/v3/', array(), '3.0.0', true );
		wp_enqueue_script( 'leaflet-js', 'https://unpkg.com/leaflet@1.9.3/dist/leaflet.js', array(), '1.9.4', true );
		wp_enqueue_script( 'firebase-app', 'https://www.gstatic.com/firebasejs/11.3.0/firebase-app-compat.js', array(), '11.3.0', true );
		wp_enqueue_script( 'firebase-auth', 'https://www.gstatic.com/firebasejs/11.3.0/firebase-auth-compat.js', array(), '11.3.0', true );
		wp_enqueue_script( 'jwt-decode', 'https://cdn.jsdelivr.net/npm/jwt-decode@4.0.0/build/cjs/index.min.js', array(), '9.6.0', true );
		wp_enqueue_script( 'sdk-facebook', 'https://connect.facebook.net/en_US/sdk.js', array(), 'v19.0', false );
		wp_enqueue_script( 'sdk-google', 'https://accounts.google.com/gsi/client?hl=en', array(), 'v2', false );

		wp_enqueue_script( 'axiosJs', SAS_URL . 'src/services/axios.js', array( 'axios-cdn', 'sas-window-env' ), $version_plugin, true );
		wp_enqueue_script( 'advanced-search', SAS_URL . 'src/utils/advancedSearch.js', array(), $version_plugin, true );
		wp_enqueue_script( 'lodash-merge', SAS_URL . 'src/utils/lodashMerge.js', array(), $version_plugin, true );
		wp_enqueue_script( 'filter-js', SAS_URL . 'src/utils/filter.js', array( 'moment' ), $version_plugin, true );
		wp_enqueue_script( 'intersection', SAS_URL . 'src/utils/observe-intersection.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-url', SAS_URL . 'src/composables/useUrl.js', array( 'vue-cdn' ), $version_plugin, true );
		wp_enqueue_script( 'use-sas-property-search', SAS_URL . 'src/composables/useSasPropertySearch.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-google-auth', SAS_URL . 'src/composables/google-auth.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-facebook-auth', SAS_URL . 'src/composables/facebook-auth.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-axios', SAS_URL . 'src/composables/useAxios.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-error', SAS_URL . 'src/composables/useError.js', array( 'vue-cdn' ), $version_plugin, true );
		wp_enqueue_script( 'use-property', SAS_URL . 'src/composables/useProperty.js', array( 'vue-cdn' ), $version_plugin, true );
		wp_enqueue_script( 'use-storage', SAS_URL . 'src/composables/useStorage.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-useimask', SAS_URL . 'src/composables/useImask.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-place', SAS_URL . 'src/composables/usePlace.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-osm-place', SAS_URL . 'src/composables/useOsmPlace.js', array(), $version_plugin, true );
		wp_enqueue_script( 'axios-options', SAS_URL . 'src/services/axiosOptions.js', array( 'vue-cdn' ), $version_plugin, true );
		wp_enqueue_script( 'country-metas', SAS_URL . 'src/services/countryMetas.js', array( 'vue-cdn' ), $version_plugin, true );
		wp_enqueue_script( 'auth-social-store', SAS_URL . 'src/store/auth-social.js', array(), $version_plugin, true );
		wp_enqueue_script( 'property-store', SAS_URL . 'src/store/properties.js', array(), $version_plugin, true );
		wp_enqueue_script( 'user-store', SAS_URL . 'src/store/user.js', array(), $version_plugin, true );
		wp_enqueue_script( 'validation-email-store', SAS_URL . 'src/store/validation-email.js', array(), $version_plugin, true );
		wp_enqueue_script( 'calendar-store', SAS_URL . 'src/store/calendar.js', array(), $version_plugin, true );
		wp_enqueue_script( 'maps-store', SAS_URL . 'src/store/maps.js', array(), $version_plugin, true );
		wp_enqueue_script( 'use-stripe', SAS_URL . 'src/store/stripe.js', array(), $version_plugin, true );
		wp_enqueue_script( 'vue-modules', SAS_URL . 'app.js', array( 'vue-cdn' ), $version_plugin, true );
		
		wp_enqueue_script( 'sas-ajax-script', SAS_URL . 'js/sas-ajax.js', array( 'jquery' ), $version_plugin, true );
		wp_enqueue_script( 'sas-window-env', SAS_URL . 'js/sas-window-env.js?v=' . gmdate('Ymdhis'), [], $version_plugin, true );
		wp_localize_script( 'sas-ajax-script', 'sas_ajax_obj', array(
			'ajax_url' => admin_url( 'admin-ajax.php' )
		) );
	}
	public static function write_file() {
		global $wp_filesystem;

		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}

		// Initialize the WordPress Filesystem API
		if ( ! WP_Filesystem() ) {
			return;
		}

		$settings    = new Settings();
		$property    = new PropertyRepository();
		$propertyDTO = $property->get( $settings->get( 'sas_one_property_page_id' ) )->getCachedPropertyData( 'property' )['data'] ?? '';
		$filename    = plugin_dir_path( __FILE__ ) . "js/sas-window-env.js";

		$file_content = "window.SAS_URL = '" . esc_url( rtrim( SAS_URL, '/' ) ) . "';";
		$file_content .= "window.propertyData = " . wp_json_encode( $propertyDTO ) . ";";
		$file_content .= "window.env = " . wp_json_encode( $settings->all()['data'] ?? [] ) . ";";

		if ( false === $wp_filesystem->put_contents( $filename, $file_content ) ) {
			return;
		}
	}

    public static function update_sas_config(\Saswp\DTOs\SasSettingsDTO $sasSettingsDTO){
        $settings    = new Settings();
        $api = new Saswp\Api();
            $api
            ->setApiUrl($sasSettingsDTO->sas_api_url)
            ->useJsonContentType()
            ->setApiMethod("POST")
            ->setApiUrlPath("/api/vendor/vendor_group_wordpress_config")
            ->setRequestData(['vendor_group_wordpress' => [
                'single' => (bool) $sasSettingsDTO->sas_one_property_page_flag == '1'? 1: 0, 'main_property_id' => $sasSettingsDTO->sas_one_property_page_id]
                ])
            ->setApiToken($settings->get("sas_api_token", ''))
            ->doRequest();
        

    }

	public static function init_api() {
		// Inicializa rotas de API
	}

	public static function init_shortcodes() {
		// Inicializa shortcodes
	}
}

SAS_Plugin::init();
