<?php

namespace Saswp\Api\Booking;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class BookingInterhomeCancelController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/booking/interhome/cancel/:booking";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $apiUrl = str_replace(":booking", $_params['booking'] ?? '', $this->apiUrl);

        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($apiUrl)
            ->setApiMethod("DELETE")
            ->setRequestData($_params)
            ->withAuthenticationBearer()
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
