<?php

namespace Saswp\Api\Booking;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class BookingPaymentParcelController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api//booking/do_payment/:bookingPaymentParcel";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $apiUrl = str_replace(":bookingPaymentParcel", $_params['bookingPaymentParcel'] ?? '', $this->apiUrl);

        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($apiUrl)
            ->setApiMethod("POST")
            ->setRequestData($_params)
            ->withAuthenticationBearer()
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
