<?php

namespace Saswp\Api\Public;
use Saswp\Api;
use Saswp\DTOs\Response\PropertyListDTO;
use Saswp\Settings;
use WP_REST_Request;

class PropertyCategoriesListController
{
    private Api $api;
    private Settings $settings;
    private PropertyListDTO $propertyListDTO;
    private $apiUrl = "/api/property-categories";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setRequestData([])
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
