<?php

namespace Saswp\Api\Vendor;
use Saswp\Api;
use Saswp\DTOs\Response\PropertyListDTO;
use Saswp\DTOs\SasSettingsDTO;
use Saswp\Settings;
use WP_REST_Request;

class VendorGroupApi
{
    private Api $api;
    private Settings $settings;
    private PropertyListDTO $propertyListDTO;
    private $apiUrl = "/api/vendor/vendor_group/list_locations";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setRequestData(['customer'  => $customer])
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
