<?php

namespace Saswp\Api\Vendor;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class VendorGroupWordpressCategoriesController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/vendor/vendor_group/wordpress_categories";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setApiMethod("GET")
            ->setRequestData($_params)
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
