<?php

namespace Saswp\Api\Vendor;
use Saswp\Api;
use Saswp\DTOs\Response\Vendor\ShowLeanFullDTO;
use Saswp\Settings;
use WP_REST_Request;

class VendorShowLeanFullController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/vendor/show_lean_full";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setApiMethod("GET")
            ->setRequestData($_params)
            ->withAuthenticationBearer()
            //->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();

        $result = $this->api->getResult();
        if (isset($result['data']['vendors'])) {
            $showLeanFullDTO = new ShowLeanFullDTO($result['data']['vendors'] ?? []);
            unset($result['data']);
            $result['data']['vendors'] = $showLeanFullDTO->toArray();
        }
        return $result;
    }


}
