function useOsmPlace(place = {}) {
	let r = {
		address: null,
		postcode: null,
		suburb: null,
		formatted: null,
		city: null,
		state: null,
		country: null,
		state_code: null,
		country_code: null,
	};

	if (place.error) {
		return r;
	}

	if (!!place.place_id) {
		r.address = place.address.road || place.address.route || null;
		r.postcode = place.address.postcode || null;
		r.suburb = place.address.suburb || null;
		r.city =
			place.address.city ||
			place.address.town ||
			place.address.quarter ||
			place.address.village ||
			place.address.county ||
			null;
		r.state = place.address.state || null;
		r.state_code = place.address["ISO3166-2-lvl4"]
			? place.address["ISO3166-2-lvl4"].split("-").at(1)
			: null;
		r.country = place.address.country || null;
		r.country_code = place.address.country_code || null;
		r.formatted = [r.address, r.suburb, r.city, r.state, r.country]
			.filter((v) => !!v)
			.join(", ");
		r.ignore_bookings = 1;
		r.boundary = 1;

		return r;
	} else {
		r.address = place.address || null;
		r.suburb = place.suburb || null;
		r.city = place.city || place.country || null;
		r.state = place.state || null;
		r.country = place.country || null;
		r.country_code = place.country_code || null;
		r.postcode = place.postcode || null;
		r.state_code = place.state_code || null;
		r.formatted =
			place.formatted ??
			[r.suburb, r?.city, r.state, r.country]
				.filter((v) => !!v)
				.join(", ");
		r.ignore_bookings = 1;
		r.boundary = 1;

		return r;
	}

	return place;
}

window.useOsmPlace = useOsmPlace;
