const useSasPropertySearch = (options = {}) => {
	const r = useAxios({
		url: '',
		method: 'get',
		...options,
		params: {},
		response: {
			data: {
				entities: [],
				list_nearby: [],
				pagination: {
					count: 0,
					current_page: 0,
					per_page: 0,
					total: 0,
					total_pages: 0,
				},
			},
		},

		paramsClear() {
			this.params = this.paramsDefault();
		},

		paramsDefault(merge = {}) {
			if (typeof merge == 'string') {
				if (merge == 'query') {
					const query = location.href.search;
					merge = {};
				}
			}

			merge = lodash.merge({
				search: {
					bedrooms: null,
					bathrooms: null,
					parking: null,
					access_opt: null,
					guests: null,
					restrictions: null,
					ne_lat: null,
					ne_lng: null,
					sw_lat: null,
					sw_lng: null,
					initial_date: null,
					final_date: null,
					min_price: null,
					max_price: null,
					full_address: null,
					route: null,
					city: null,
					state: null,
					country: null,
					country_code: null,
					suburb: '',
					guests_adults: 1,
					postal_code: null,
					property_types: [],
					holiday_types: [],
					amenities: [],
					accessibility: false,
					sustainability: false,
					pets: false,
				},
			}, merge);

			['property_types', 'holiday_types', 'amenities'].map(attr => {
				merge.search[attr] = Array.isArray(merge.search[attr]) ? merge.search[attr] : [];
				merge.search[attr] = merge.search[attr].map(n => parseInt(n));
			});

			return merge;
		},

		paramsMerge(merge = {}) {
			r.params = lodash.merge(r.params, merge);
		},

		replaceData(data) {
			for (let attr in data) {
				r[attr] = data[attr];
			}
		},
	});
	const search = Vue.ref({})

	r.params = r.paramsDefault(r.params);
	search.value = r
	return search;
};

window.useSasPropertySearch = useSasPropertySearch
