const usePropertiesMapsStore = Pinia.defineStore({
	id: "maps",
	state: () => ({
		property: {},
		showMap: false
	}),
	actions: {
		setPropertiesMaps(property) {
			this.property = property
		},
		toggleShowMaps() {
			this.showMap = !this.showMap
		},
    setShowMaps(visible) {
			this.showMap = visible
		}
	},
	getters: {
		getPropertyMaps: (state) => state.property ?? {},
	},
});

window.usePropertiesMapsStore = usePropertiesMapsStore;
