const observeIntersection = (selector, callback, options, delay) => {
	setTimeout(() => {
		const objObserved = document.querySelector(selector);
		if (!objObserved) {
			console.error("Element not found with the provided selector.");
			return;
		}

		const observer = new IntersectionObserver(callback);
		observer.observe(objObserved);
	}, delay);
};

window.observeIntersection = observeIntersection;
