<?php

namespace Saswp\DTOs\Response;

class PropertyAmenityDTO
{

    public readonly int $id;
    public readonly int $amenity_category_id;
    public readonly string $name;
    public readonly string $active;
    public readonly int $order;
    public readonly string $amenity_category_name;
    public readonly string $icon;

    public function __construct(array $_data)
    {
        $this->id  = isset($_data['id']) ?$_data['id']:0;
        $this->amenity_category_id  = isset($_data['amenity_category_id']) ?$_data['amenity_category_id']:0;
        $this->name  = isset($_data['name']) ?$_data['name']:'';
        $this->active  = isset($_data['active']) ?$_data['active']:0;
        $this->order  = isset($_data['order']) ?$_data['order']:0;
        $this->amenity_category_name  = isset($_data['amenity_category']['name']) ?$_data['amenity_category']['name']:'';
        $this->convertIcon();
    }

    public function toArray(): array
    {
        return (array)$this;
    }

    public function convertIcon(){
        $iconKey = 'fa-check';
        $icons = [
            'material-symbols:clean-hands' => ['clean', 'sanitary'],
            'ic:baseline-delivery-dining' => ['delivery'],
            'mdi-air-conditioner' => ['air'],
            'mdi-wifi' => ['wireless', 'wifi', 'wi-fi', 'internet'],
            'mdi-pool' => ['outdoor pool'],
            'mdi-stove' => ['stove'],
            'mdi-leaf' => ['sustainability'],
            'mdi-wheelchair-accessibility' => ['accessibility'],
            'mdi-fridge' => ['refrigerator'],
            'mdi-toaster-oven' => ['oven'],
            'mdi-bed-double' => ['bedroom'],
            'mdi-shower-head' => ['bathroom'],
            'fluent:vehicle-car-parking-16-filled' => ['parking'],
            'mdi-silverware-variant' => ['dishes', 'cutlery'],
            'fa-ceiling-fan' => ['ceiling fan'],
            'mdi-hvac' => ['gas heating'],
            'mdi-silverware-fork-knife' => ['cookware'],
            'mdi-shaker-outline' => ['cooking', 'salt'],
            'mdi-television' => ['tv'],
            'fa-smoking' => ['smoking allowed'],
            'mdi-smoke-detector' => ['smoke detector'],
            'mdi-grass' => ['backyard'],
            'mdi-balcony' => ['balcony'],
            'mdi-fire-extinguisher' => ['fire extinguisher'],
            'mdi-police-badge' => ['police'],
            'mdi-medical-bag' => ['medical', 'first aid'],
            'mdi-paw' => ['pets'],
            'guidance:no-pets-allowed' => ['no pets'],
            'mdi-cancel' => ['no parties'],
            'fa-ban-smoking' => ['no smoking'],
            'mdi-face-mask' => ['face mask'],
            'mdi-lotion-plus' => ['sanitizer'],
            'mdi-social-distance-2-meters' => ['social distancing'],
            'mdi-account-switch' => ['contactless check-out'],
            'mdi-table-furniture' => ['outdoor furniture'],
            'mdi-grill' => ['outdoor barbecue', 'bbq barbecue'],
            'mdi-spray-bottle' => ['enhanced cleaning'],
            'mdi-beach' => ['beach'],
            'mdi-account-multiple-outline' => ['couple'],
            'ic:baseline-kitchen' => ['kitchen'],
            'material-symbols:elevator' => ['lift elevator'],
            'material-symbols:coffee-maker' => ['coffee'],
            'healthicons:city' => ['city'],
            'ion:snow' => ['snow'],
            'fontisto:sait-boat' => ['lake'],
            'maki:farm' => ['farm', 'farmstay'],
            'fa-solid:tractor' => ['rural'],
            'ph:wine-fill' => ['wineries'],
            'fa6-solid:tree-city' => ['regional area'],
            'game-icons:outback-hat' => ['outback'],
            'map:skiing' => ['skiing'],
            'material-symbols:dinner-dining' => ['epicurean'],
            'material-symbols:surfing' => ['surfing'],
            'gis:search-country' => ['country'],
            'map:abseiling' => ['adventure'],
            'clarity:on-holiday-solid' => ['holiday'],
            'material-symbols:forest' => ['nature', 'bushwalking'],
            'clarity:cd-dvd-line' => ['cd', 'dvd'],
            'ant-design:safety-certificate-filled' => ['safety'],
        ];

        foreach($icons as $key => $_amenityNames){
            foreach($_amenityNames as $amenity){
                if(strstr($amenity, strtolower($this->name))){
                    $iconKey = $key;
                    break 2;
                }
            }

        }
        $this->icon = $iconKey;
    }
}
