<?php

namespace Saswp\DTOs\Response;

class PropertyDTO
{

	public readonly int $id;
	public readonly string $name;
	public readonly bool $active;
	public readonly bool $published;
	public readonly string $reference;
	public readonly string $slug;
	public readonly string $currency_code;
	public readonly string $gov_registration_ref;
	public readonly string $property_rating;
	public readonly int $age_restriction;
	public readonly int $age_restriction_active;

	public function __construct(array $_data)
	{
		$this->id = isset($_data['id']) ? $_data['id'] : 0;
		$this->name = isset($_data['name']) ? $_data['name'] : '';
		$this->active = isset($_data['active']) ? $_data['active'] : 0;
		$this->published = isset($_data['published']) ? $_data['published'] : 0;
		$this->reference = isset($_data['reference']) ? $_data['reference'] : '';
		$this->slug = isset($_data['slug']) ? $_data['slug'] : '';
		$this->currency_code = isset($_data['currency_code']) ? $_data['currency_code'] : '';
		$this->gov_registration_ref = isset($_data['gov_registration_ref']) ? $_data['gov_registration_ref'] : '';
		$this->property_rating = isset($_data['property_rating']) ? $_data['property_rating'] : '';
		$this->age_restriction = isset($_data['age_restriction']) ? $_data['age_restriction'] : 0;
		$this->age_restriction_active = isset($_data['age_restriction_active']) ? $_data['age_restriction_active'] : 0;
	}

	public function toArray(): array
	{
		return (array)$this;
	}
}
