<?php

namespace Saswp\DTOs\Response;

class PropertyPricingDTO
{

    public readonly int $id;
    public readonly float $base_price;
    public readonly float $bond;
    public readonly float $booking_fee;
    public readonly float $weekend_rate;
    public readonly array $weekend_days;
    public readonly int $minimum_stay;
    public readonly int $weekend_active_flag;
    public readonly int $guest_configuration_flag;
    public readonly int $guest_configuration;
    public readonly float $price_per_guest;
    public readonly int $pet_configuration_flag;
    public readonly int $pet_configuration;
    public readonly float $price_per_pet;
    public readonly int $checkin_active_flag;
    public readonly array $check_in_days;
    public readonly int $checkout_active_flag;
    public readonly array $check_out_days;

    public function __construct(array $_data)
    {
        $this->id  = isset($_data['id']) ?$_data['id']:0;
        $this->base_price  = isset($_data['base_price']) ?$_data['base_price']:0;
        $this->bond  = isset($_data['bond']) ?$_data['bond']:0;
        $this->booking_fee  = isset($_data['booking_fee']) ?$_data['booking_fee']:0;
        $this->weekend_rate  = isset($_data['weekend_rate']) ?$_data['weekend_rate']:0;
        $this->weekend_days  = isset($_data['weekend_days']) ?$_data['weekend_days']:[];
        $this->minimum_stay  = isset($_data['minimum_stay']) ?$_data['minimum_stay']:1;
        $this->weekend_active_flag  = isset($_data['weekend_active_flag']) ?$_data['weekend_active_flag']:0;
        $this->guest_configuration_flag  = isset($_data['guest_configuration_flag']) ?$_data['guest_configuration_flag']:0;
        $this->guest_configuration  = isset($_data['guest_configuration']) ?$_data['guest_configuration']:0;
        $this->price_per_guest  = isset($_data['price_per_guest']) ?$_data['price_per_guest']:0;
        $this->pet_configuration_flag  = isset($_data['pet_configuration_flag']) ?$_data['pet_configuration_flag']:0;
        $this->pet_configuration  = isset($_data['pet_configuration']) ?$_data['pet_configuration']:0;
        $this->price_per_pet  = isset($_data['price_per_pet']) ?$_data['price_per_pet']:0;
        $this->checkin_active_flag  = isset($_data['checkin_active_flag']) ?$_data['checkin_active_flag']:0;
        $this->check_in_days  = isset($_data['check_in_days']) ?$_data['check_in_days']:[];
        $this->checkout_active_flag  = isset($_data['checkout_active_flag']) ?$_data['checkout_active_flag']:0;
        $this->check_out_days  = isset($_data['check_out_days']) ?$_data['check_out_days']:[];
    }

    public function toArray(): array
    {
        return (array)$this;
    }
}
