<?php

namespace Saswp;

function property_rating_shortcode()
{
    $settings = new \Saswp\Settings();
    $property = new \Saswp\Repository\PropertyRepository();
    $propertyDTO = $property->get($settings->get('sas_one_property_page_id'))->getProperty();
    if ($propertyDTO->id) {
        $property_rating = $propertyDTO->property_rating;

        // Extraia a parte inteira e decimal da avaliação
        $rating = intval($property_rating);
        $rating_decimal = $property_rating - $rating;

        $stars = '';

        for ($i = 1; $i <= 5; $i++) {
            if ($i <= $rating) {
                $stars .= '<i class="fa-solid fa-star"></i>';
            } elseif ($i === $rating + 1 && $rating_decimal > 0) {
                $stars .= '<i class="fa-solid fa-star-half-stroke"></i>';
            } else {
                $stars .= '<i class="fa-regular fa-star"></i>';
            }
        }

        return '<div class="property-rating star-rating">' . $stars . '</div>';
    } 
    return '<div class="property-rating" data-shortcode="property_rating"></div>';
}
?>