<?php
$api = new \Saswp\Api();
$settings =  new \Saswp\Settings();
// wp-json/saswp/settings/save
$api->setApiRequest('POST', '/settings/save', function($data) {
    return (new \Saswp\Settings)->save($data);
});
$api->setApiRequest('GET', '/settings/propertyList', function($data) {
    return (new \Saswp\Api\Admin\PropertyListController)->retrieveProperties($data);
});
$route = $settings->get('sas_route_vendor_property_main_featured');
$routeGuest = $settings->get('sas_guest_panel_route');
\Saswp\Route::add("^{$routeGuest}/?$", 'guest.php');
\Saswp\Route::add("^{$routeGuest}/settings", 'guest.php');
\Saswp\Route::add("^{$routeGuest}/booking/([0-9]+)/?", 'guest.php');
\Saswp\Route::add("^{$route}/?$", 'property.php');
\Saswp\Route::add("^{$route}/(\d+)/(\w+)/?", 'property-slug.php');
\Saswp\Route::add("^recovery/([a-zA-Z0-9]+)/?$", 'recovery.php');

// API Routes

// Admin
$api->setApiRequest('GET', '/admin/vendor_group_wordpress_categories', new \Saswp\Api\Account\PasswordRecoverController());

// Public
$api->setApiRequest('POST', '/account/password_recover', new \Saswp\Api\Account\PasswordRecoverController());
$api->setApiRequest('GET', '/(?P<token>\S+)/show_by_token', new \Saswp\Api\Account\ValidateTokenRecoveryController());
$api->setApiRequest('GET', '/account/validate_token_recovery', new \Saswp\Api\Account\ValidateTokenRecoveryController());
// Booking
$api->setApiRequest('GET', '/booking', new \Saswp\Api\Booking\BookingListController());
$api->setApiRequest('GET', '/booking/(?P<booking>\d+)', new \Saswp\Api\Booking\BookingShowController());
$api->setApiRequest('POST', '/booking/rating', new \Saswp\Api\Booking\BookingRatingStoreController());
$api->setApiRequest('POST', '/booking/do_payment/(?P<bookingPaymentParcel>\d+)', new \Saswp\Api\Booking\BookingShowController());
$api->setApiRequest('GET', '/booking/booking_messages', callback: new \Saswp\Api\Booking\BookingMessagesController());
$api->setApiRequest('POST', '/booking/store', callback: new \Saswp\Api\Booking\BookingStoreController());
$api->setApiRequest('POST', '/booking/refund_payment/(?P<booking>\d+)', new \Saswp\Api\Booking\BookingRefundPaymentController());
$api->setApiRequest('DELETE', '/booking/interhome/cancel/(?P<booking>\d+)', new \Saswp\Api\Booking\BookingInterhomeCancelController());

$api->setApiRequest('POST', '/guest/quick_store', new \Saswp\Api\Guest\QuickStoreController());
$api->setApiRequest('GET', '/guest/properties/(?P<property>\d+)/(?P<slug>\S+)', new \Saswp\Api\Guest\GuestPropertyShowController());
// Public
$api->setApiRequest('GET', '/public/amenities_by_categories', new \Saswp\Api\Public\AmenitiesByCategoriesListController());
$api->setApiRequest('GET', '/public/property_types', new \Saswp\Api\Public\PropertyTypesListController());
$api->setApiRequest('GET', '/public/amenities', new \Saswp\Api\Public\AmenitiesListController());
$api->setApiRequest('GET', '/public/holiday_types', new \Saswp\Api\Public\HolidayTypesListController());
$api->setApiRequest('POST', '/public/token_test', new \Saswp\Api\Public\TokenTestController());
$api->setApiRequest('GET', '/public/trigger_sites', new \Saswp\Api\Public\TriggerSitesController());
$api->setApiRequest('GET', '/public/trigger_sitemap_download', new \Saswp\Api\Public\TriggerSitemapDowloadController());

// Property
$api->setApiRequest('GET', '/properties', new \Saswp\Api\Property\PropertyListController());
$api->setApiRequest('GET', '/properties/search', new \Saswp\Api\Property\PropertySearchController());
$api->setApiRequest('GET', '/properties/wordpress/search', new \Saswp\Api\Property\WordpressSearchController());
$api->setApiRequest('GET', '/property-categories', new \Saswp\Api\Public\PropertyCategoriesListController());

// Quote
$api->setApiRequest('POST', '/quotes/store', new \Saswp\Api\Quote\QuoteStoreController());

// Vendor Agents
$api->setApiRequest('GET', '/vendor/agents/(?P<agent>\d+)', new \Saswp\Api\VendorAgent\VendorAgentListController);
$api->setApiRequest('PUT', '/vendor/agents/(?P<agent>\d+)', new \Saswp\Api\VendorAgent\VendorAgentUpdateController);

// Vendor
$api->setApiRequest('POST', '/vendor/login_json', new \Saswp\Api\Vendor\VendorLoginJsonController);
$api->setApiRequest('DELETE', '/vendor/financial/stripe/destroy_payment_method', new \Saswp\Api\Vendor\Financial\Stripe\DestroyPaymentMethodController);
$api->setApiRequest('GET', '/vendor/property_booking_approvals', new \Saswp\Api\Vendor\VendorGroupWordpressCategoriesController);
$api->setApiRequest('GET', '/vendor/vendor_group_wordpress_categories', new \Saswp\Api\Vendor\VendorGroupWordpressCategoriesController);
$api->setApiRequest('GET', '/vendor/show_lean_full', new \Saswp\Api\Vendor\VendorShowLeanFullController);
$api->setApiRequest('GET', '/vendor/stripe_keys', new \Saswp\Api\Vendor\VendorStripeKeysController);
// Vendor Group
$api->setApiRequest('GET', '/vendor/vendor_group/list_locations', new \Saswp\Api\Vendor\VendorGroupListLocationController);
