<?php

/**
 * Plugin Name:       Search and Stay
 * Plugin URI:        https://searchandstay.com
 * Description:       Create your own booking list website with your listed Search and Stay properties
 * Author:            Search and Stay
 * Author URI:        https://searchandstay.com
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       searchandstay
 * Domain Path:       /languages
 * Version:           1.4.15
 *
 * @package         Sas_Wp_Plugin
 */
require_once __DIR__ . '/vendor/autoload.php';

if (!defined('WPINC')) {
    die();
}

define('SAS_MAIN_FILE_PATH', __FILE__);

define('SASWP_API_URL', getenv('SASWP_API_URL') ? getenv('SASWP_API_URL') : 'http://sys-dev.searchandstay.com');

// Including sas-init.php file
if (file_exists(plugin_dir_path(__FILE__) . 'sas-init.php')) {
    require_once(plugin_dir_path(__FILE__) . 'sas-init.php');
}
// Including sas-plugin.php file
if (file_exists(plugin_dir_path(__FILE__) . 'sas-plugin.php')) {
    require_once(plugin_dir_path(__FILE__) . 'sas-plugin.php');
}

// Hooks
include __DIR__ . '/hooks/scripts-styles.php';

// Admin Pages
include __DIR__ . '/pages/admin/admin-hooks.php';

// Endpoints
include __DIR__ . '/routes/routes.php';
