<?php

namespace Saswp\Api\Booking;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class BookingRatingStoreController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/booking/rating";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiMethod("POST")
            ->setApiUrlPath($this->apiUrl)
            ->setRequestData($_params)
            ->withAuthenticationBearer()
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
