<?php

namespace Saswp\Api\Guest;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class GuestPropertyShowController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/guest/properties/:property/:slug";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $apiUrl = str_replace(":property", $_params['property'] ?? '', $this->apiUrl);
        $apiUrl = str_replace(":slug", $_params['slug'] ?? '', $apiUrl);
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($apiUrl)
            ->setRequestData($_params)
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();
        return $this->api->getResult();
    }


}
