<?php

namespace Saswp\Api\Guest;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class QuickStoreController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/guest/quick_store";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        if(!isset($_params["g-recaptcha-response"])){
            $_params["g-recaptcha-response"] = "100";
        }
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setApiMethod("POST")
            ->setRequestData($_params)
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
