<?php

namespace Saswp\Api\Property;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class PropertyListController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/properties";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];

        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setRequestData($_params)
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
