<?php

namespace Saswp\Api\Public;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class AmenitiesByCategoriesListController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/public/amenities_by_categories";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setRequestData($_params)
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
