<?php

namespace Saswp\Api\Public;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class TokenTestController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/vendor/token_test";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($this->apiUrl)
            ->setApiMethod("POST")
            ->setRequestData([])
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
