<?php

namespace Saswp\Api\Vendor\Financial\Stripe;
use Saswp\Api;
use Saswp\DTOs\Response\PropertyListDTO;
use Saswp\Settings;
use WP_REST_Request;

class DestroyPaymentMethodController
{
    private Api $api;
    private Settings $settings;
    private PropertyListDTO $propertyListDTO;
    private $apiUrl = "/api/vendor/financial/stripe/destroy_payment_method";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiMethod("DELETE")
            ->setApiUrlPath($this->apiUrl)
            ->useJsonContentType()            
            ->setRequestData($wpRestRequest->params['JSON'] ?? [])
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
