<?php

namespace Saswp\Api\VendorAgent;
use Saswp\Api;
use Saswp\Settings;
use WP_REST_Request;

class VendorAgentUpdateController
{
    private Api $api;
    private Settings $settings;
    private $apiUrl = "/api/vendor/agents/:agent";

    public function __construct(){
        $this->api = new Api();
        $this->settings = new Settings();
    }
    public function __invoke(WP_REST_Request $wpRestRequest):array
    {
        $_params = $wpRestRequest->get_params() ?? [];
        $apiUrl = str_replace(":agent", $_params['agent'] ?? '', $this->apiUrl);
        
        $this->api
            ->setApiUrl($this->settings->getFullUrl())
            ->setApiUrlPath($apiUrl)
            ->setApiMethod("PUT")
            ->setRequestData($_params)
            ->withAuthenticationBearer()
            ->setApiToken($this->settings->get("sas_api_token", ''))
            ->doRequest();


        return $this->api->getResult();
    }


}
