<?php

namespace Saswp\Repository;
use Saswp\DTOs\Response\PropertyAmenityDTO;
use Saswp\DTOs\Response\PropertyBasicInformationDTO;
use Saswp\DTOs\Response\PropertyConfigurationDTO;
use Saswp\DTOs\Response\PropertyDescriptionDTO;
use Saswp\DTOs\Response\PropertyDTO;
use Saswp\DTOs\Response\PropertyHouseConfigurationDTO;
use Saswp\DTOs\Response\PropertyHouseRuleDTO;
use Saswp\DTOs\Response\PropertyImageDTO;
use Saswp\DTOs\Response\PropertyLocationDTO;
use Saswp\DTOs\Response\PropertyPricingDTO;

class PropertyRepository
{
    const ENDPOINT_PROPERTY_SHOW = "/api/vendor/properties/:propertyId";

    private int $propertyId = 0;
    private array $_parameters = [];
    private array $endpoint = [];
    private PropertyDTO $property ;
    private PropertyBasicInformationDTO $propertyBasicInformation ;
    private PropertyConfigurationDTO $propertyConfiguration;
    private PropertyDescriptionDTO $propertyDescription ;
    private PropertyLocationDTO $propertyLocation ;
    private PropertyPricingDTO $propertyPricing ;
    private int $propertyBedroomCount = 0;
    private array $propertyAmenities = [] ;
    private array $propertyHouseConfigurations = [] ;
    private array $propertyHouseRules = [] ;
    private array $propertyImages = [] ;
    public function __construct(){
        $this->property = new PropertyDTO([]);
        $this->propertyBasicInformation = new PropertyBasicInformationDTO([]);
        $this->propertyConfiguration = new PropertyConfigurationDTO([]);
        $this->propertyDescription = new PropertyDescriptionDTO([]);
        $this->propertyLocation = new PropertyLocationDTO([]);
        $this->propertyPricing = new PropertyPricingDTO([]);
    }

    public function getPropertyAmenities(): array{
        return $this->propertyAmenities;
    }

    public function getProperty(): PropertyDTO{
        return $this->property;
    }

    public function getPropertyBasicInformation(): PropertyBasicInformationDTO{
        return $this->propertyBasicInformation;
    }

    public function getPropertyConfiguration(): PropertyConfigurationDTO{
        return $this->propertyConfiguration;
    }

    public function getPropertyBedroomCount(): int{
        return $this->propertyBedroomCount;
    }

    public function getPropertyDescription(): PropertyDescriptionDTO{
        return $this->propertyDescription;
    }

    public function getPropertyHouseConfigurations(): array{
        return $this->propertyHouseConfigurations;
    }
    public function getPropertyHouseRules(): array{
        return $this->propertyHouseRules;
    }

    public function getPropertyImages(): array{
        return $this->propertyImages;
    }
    public function getPropertyLocation(): PropertyLocationDTO{
        return $this->propertyLocation;
    }

    public function getPropertyPricing(): PropertyPricingDTO{
        return $this->propertyPricing;
    }

    public function get($id=0):self
    {
        $this->propertyId = $id;
        $this->_parameters = ["propertyId" => $id];
        $this->property = new PropertyDTO($this->getCachedPropertyData('property')['data']['properties']?? []);
        $this->propertyBasicInformation = new PropertyBasicInformationDTO($this->getCachedPropertyData('property')['data']['property_basic_informations']?? []);
        $this->propertyConfiguration = new PropertyConfigurationDTO($this->getCachedPropertyData('property')['data']['property_configurations']?? []);
        $this->propertyPricing = new PropertyPricingDTO($this->getCachedPropertyData('property')['data']['property_pricings']?? []);
        $this->propertyDescription = new PropertyDescriptionDTO($this->getCachedPropertyData('property')['data']['property_descriptions']?? []);
        $this->propertyLocation = new PropertyLocationDTO($this->getCachedPropertyData('property')['data']['property_locations']?? []);
        $this->parsePropertyImages($this->getCachedPropertyData('property')['data']['property_images'] ?? []);
        $this->parsePropertyAmenities($this->getCachedPropertyData('property')['data']['property_amenities'] ?? []);
        $this->parsePropertyHouseConfigurations($this->getCachedPropertyData('property')['data']['property_house_configurations'] ?? []);
        $this->parsePropertyHouseRules($this->getCachedPropertyData('property')['data']['property_house_rules'] ?? []);

        return $this;
    }

    public function post($path, $callback)
    {
    }

    public function put($path, $callback)
    {
    }

    public function delete($path, $callback)
    {
    }


    // Função para obter dados do cache ou da API
    function getCachedPropertyData($shortcode)
    {
        // Usar transients para armazenar em cache os dados da propriedade
        $transient_key = 'saswp_property_data_' . $shortcode;
        $cached_data = get_transient($transient_key);

        if ($cached_data !== false) {
            return $cached_data;
        }

        // Se não houver dados em cache, buscar da API
        $property_data = $this->fetchModelData($shortcode);

        if ($property_data !== null) {
            // Armazenar os dados no cache por 1 dia (86400 segundos)
            set_transient($transient_key, $property_data, 5);
        }

        return $property_data;
    }

    private function parseEndpointVars(string $endpoint, array $_vars): string{
        foreach($_vars as $key => $value){
            $endpoint = str_replace(":". $key, $value ,$endpoint);
        }
        return $endpoint;
    }

    private function parsePropertyAmenities(array $propertyAmenities){
        $this->propertyAmenities = [];
        foreach($propertyAmenities as $propertyAmenity){
            $this->propertyAmenities[] = new PropertyAmenityDTO($propertyAmenity);
        }
        return $this;
    }

    private function parsePropertyHouseConfigurations(array $propertyHouseConfigurations){
        $this->propertyHouseConfigurations = [];
        foreach($propertyHouseConfigurations as $propertyHouseConfiguration){
            $dto = new PropertyHouseConfigurationDTO($propertyHouseConfiguration);
            $this->propertyHouseConfigurations[] = $dto;
            if(strstr($dto->room_type_name, "Bedroom")){
                $this->propertyBedroomCount++;
            }
        }
        return $this;
    }
    private function parsePropertyHouseRules(array $propertyHouseRules){
        $this->propertyHouseRules = [];
        foreach($propertyHouseRules as $propertyHouseRule){
            $this->propertyHouseRules[] = new PropertyHouseRuleDTO($propertyHouseRule);
        }
        return $this;
    }

    private function parsePropertyImages(array $propertyImages){
        $this->propertyImages = [];
        foreach($propertyImages as $propertyImage){
            $this->propertyImages[] = new PropertyImageDTO($propertyImage);
        }
        return $this;
    }


    function fetchModelData($data_type):array
    {
        $settings = new \Saswp\Settings();
        $api_url_base = $settings->get('sas_api_url');
        $api_token = $settings->get('sas_api_token');
        $api = new \Saswp\Api();
        
        $api
            ->setApiToken($api_token)
            ->setApiUrl($api_url_base)
            ->get($this->parseEndpointVars(self::ENDPOINT_PROPERTY_SHOW, $this->_parameters));

        
        return $api->getResult();
    }
}
