<?php

namespace Saswp;

class Route
{
  static function add($route, $file, $callback=null) {
    
    add_filter('query_vars', function($query_vars) {
      $query_vars[] = 'saswp_page';
      return $query_vars;
    });

    add_action('init', function() use($file, $route) {
      add_rewrite_rule($route, "index.php?saswp_page={$file}", 'top');
      flush_rewrite_rules();
    }, 10, 0);

    add_action('template_include', function($template) use($file) {
      if ($saswp_page = get_query_var('saswp_page')) {
        return realpath(__DIR__ . "/../pages/{$saswp_page}");
      }

      return $template;
    });
  }
}
