function useAxios(options = {}) {
	options = window.axiosOptions(
		lodash.merge(
			{
				loading: false,
				success: false,
				autoSubmit: false,
				url: "",
				method: "get",
				error: window.useError(),
				headers: {},
				params: {},
				data: {},
				response: false,
				timeout: 1000,
				onBeforeRequest: () => {},
				onSuccess: () => {},
				onError: () => {},
				onResponse: () => {},
				onBeforeMount: () => {},
			},
			options,
		),
	);

	const r = Vue.reactive({
		...options,

		success: false,
		requests: 0,

		async submit(submitOptions = {}) {
			return new Promise((resolve, reject) => {
				options.error.clear();
				r.success = false;
				options.onBeforeRequest(r);

				if (r.loading) {
					clearTimeout(r.loading);
					r.loading = false;
				}

				r.loading = setTimeout(async () => {
					try {
						submitOptions = {
							method: r.method,
							url: r.url,
							params: r.params,
							data: r.data,
							headers: {
								...r.headers,
							},
							...submitOptions,
						};

						const resp = await axios(submitOptions);
						r.requests++;
						r.response = resp.data;
						options.onSuccess(resp);
						options.onResponse(resp);
						resolve(resp);
						r.success = true;
					} catch (err) {
						if (
							[403, 409].includes(
								err?.response?.data?.errors?.status ?? "",
							) &&
							window.useUserStore().getLogin?.access_token
						) {
							window.useUserStore().setLogout();
						}
						r.loading = false;
						r.error.setData(err);
						options.onError(err.response);
						options.onResponse(options.error);
						resolve(options.error);
					}
					r.loading = false;
				}, options.timeout);
			});
		},
	});

	if (options.autoSubmit) {
		r.submit();
	}

	Vue.onBeforeMount(() => {
		options.onBeforeMount(r);
	});

	return r;
}

window.useAxios = useAxios;
