const useImask = () => {
	return {
		phoneCountry(countryCode = null) {
			if (countryCode === null) return false;
			const country = countryMetas(countryCode);
			if (!country) return false;
			return {
				mask: country.phone.masks.map(mask => ({mask: mask.replace(/#/g, '0')})),
			};
		},
	};
};

window.useImask = useImask;
