const usePlace = (options = {}) => {
	options = lodash.merge({
		params: {},
	}, options);

	const r = Vue.ref({
		country: {
			loading: false,
			params: {},
			data: [],
			async load() {
				if (this.loading) clearTimeout(this.loading);
				this.loading = setTimeout(async () => {
					const {data} = await axios.get('http://overpass-api.de/api/interpreter?data=[out:json];relation["boundary"="administrative"]["admin_level"="2"];out tags;');
					this.data = data.elements
						.filter(item => !!item.tags['ISO3166-1'])
						.map(item => {
							const id = item.tags['ISO3166-1'];
							return {
								id,
								name: item.tags['name:en'] || item.tags['name'],
								flag: item.tags['flag'],
								timezone: item.tags['timezone'],
								...(countryMetas(id) || {}),
							};
						});
					this.loading = false;
				}, 1000);
			},
		},

		state: {
			loading: false,
			params: {
				country: '',
			},
			data: [],
			async load(params = {}) {
				params = {...this.params, ...params};
				if (!params.country) return;
				params.country = params.country.toUpperCase();
				if (this.loading) clearTimeout(this.loading);
				this.loading = setTimeout(async () => {
					const {data} = await axios.get(`http://overpass-api.de/api/interpreter?data=[out:json];relation["ISO3166-2"~"^${params.country}-"];out tags;`);
					this.data = data.elements.map(item => {
						const [country, id] = item.tags['ISO3166-2'].split('-');
						return {
							id,
							name: item.tags['name:en'] || item.tags['name'],
							flag: item.tags['flag'] || '',
							country,
						};
					});
					this.loading = false;
				}, 1000);
			},
		},

		search: {
			loading: false,
			params: lodash.merge({
				format: 'json',
				addressdetails: 1,
				extratags: 1,
				limit: 10,
			}, options.params),
			data: [],
			async loadData(params = {}) {
				params = {...this.params, ...params};
				return axios.get('https://nominatim.openstreetmap.org/search.php', {params}).then(resp => {
					resp.data = resp.data.map(this.placeParse);
					return resp;
				});
			},
			async load(params = {}) {
				if (this.loading) clearTimeout(this.loading);
				this.loading = setTimeout(async () => {
					params = {...this.params, ...params};
					const {data} = await this.loadData(params);
					this.data = data;
					this.loading = false;
				}, 1000);
			},
			placeParse(place) {
				place.address = place.address || {};
				let r = {id: place.place_id || null, name: ''};
				r.address = place.address.road || place.address.route || null;
				r.postcode = place.address.postcode || 200;
				r.suburb = place.address.suburb || null;
				r.city = place.address.city || place.address.town || place.address.quarter || place.address.village || place.address.county || null;
				r.state = place.address.state || null;
				r.state_code = (place.address['ISO3166-2-lvl4'] ? place.address['ISO3166-2-lvl4'].split('-').at(1) : null);
				r.country = place.address.country || null;
				r.country_code = place.address.country_code || null;
				r.lat = place.lat || null;
				r.lng = place.lon || null;
				r.flag = (place.address.country_code ? `https://flagcdn.com/${place.address.country_code}.svg` : null);
				r.name = [r.address, r.suburb, r.city, r.state, r.country].filter(v => !!v).join(', ');
				return r;
			},
		},
	});

	r.value.country.load();
	return r;
};

window.usePlace = usePlace;
