// useUrl.js
function useUrl(options = {}) {
	const u = new URL(location.href);

	options = lodash.merge(
		{
			url: u.href,
			pathname: u.pathname,
			params: parseParams(u.search),
		},
		options,
	);

	const r = Vue.reactive({
		pathname: options.pathname,
		params: options.params,

		redirect() {
			const path = r.pathname + "?" + lodash.stringify(r.params);
			window.history.pushState({path}, "", path);
			return r;
		},

		setParams(params = {}) {
			r.params = JSON.parse(JSON.stringify(params));
			return r;
		},

		paramsMerge(merge = {}) {
			for (let attr in merge) {
				r.params[attr] = merge[attr];
			}
			return r;
		},
	});
	return r;
}

window.useUrl = useUrl;
