window.configureAxios = function () {
	axios.defaults.baseURL = `${window.env.sas_api_url}/api/`;

	axios.interceptors.request.use(
		(config) => {
			const accessToken = useUserStore().getLogin?.access_token;

			config.headers = {
				Authorization: `Bearer ${accessToken}`,
				...config.headers,
				SearchAndStayApiToken:
					config.headers.SearchAndStayApiToken === "null"
						? null
						: window.env.sas_api_token,
			};

			return config;
		},
		(error) => {
			if (
				[403, 409].includes(error.response.status) &&
				useUserStore().getLogin?.access_token
			) {
				useUserStore().setLogout();
			}
			return Promise.reject(error);
		},
	);
};

window.configureAxios();
