const countryMetas = (id = null) => {
	const data = {
		"AF": {
			"name": "Afghanistan",
			"phone": {
				"code": "+93",
				"masks": ["##-###-####"],
			},
		},
		"AX": {
			"name": "Aland Islands",
			"phone": {
				"code": "+358",
				"masks": ["(###)###-##-##"],
			},
		},
		"AL": {
			"name": "Albania",
			"phone": {
				"code": "+355",
				"masks": ["(###)###-###"],
			},
		},
		"DZ": {
			"name": "Algeria",
			"phone": {
				"code": "+213",
				"masks": ["##-###-####"],
			},
		},
		"AS": {
			"name": "American Samoa",
			"phone": {
				"code": "+1",
				"masks": ["(684)###-####"],
			},
		},
		"AD": {
			"name": "Andorra",
			"phone": {
				"code": "+376",
				"masks": ["###-###"],
			},
		},
		"AO": {
			"name": "Angola",
			"phone": {
				"code": "+244",
				"masks": ["(###)###-###"],
			},
		},
		"AI": {
			"name": "Anguilla",
			"phone": {
				"code": "+1",
				"masks": ["(264)###-####"],
			},
		},
		"AQ": {
			"name": "Antarctica",
			"phone": {
				"code": "+672",
				"masks": ["1##-###"],
			},
		},
		"AG": {
			"name": "Antigua and Barbuda",
			"phone": {
				"code": "+1",
				"masks": ["(268)###-####"],
			},
		},
		"AR": {
			"name": "Argentina",
			"phone": {
				"code": "+54",
				"masks": ["(###)###-####"],
			},
		},
		"AM": {
			"name": "Armenia",
			"phone": {
				"code": "+374",
				"masks": ["##-###-###"],
			},
		},
		"AW": {
			"name": "Aruba",
			"phone": {
				"code": "+297",
				"masks": ["###-####"],
			},
		},
		"AC": {
			"name": "Ascension Island",
			"phone": {
				"code": "+247",
				"masks": ["####"],
			},
		},
		"AU": {
			"name": "Australia",
			"phone": {
				"code": "+61",
				"masks": ["#-####-####"],
			},
		},
		"AT": {
			"name": "Austria",
			"phone": {
				"code": "+43",
				"masks": ["(###)###-####"],
			},
		},
		"AZ": {
			"name": "Azerbaijan",
			"phone": {
				"code": "+994",
				"masks": ["##-###-##-##"],
			},
		},
		"BS": {
			"name": "Bahamas",
			"phone": {
				"code": "+1",
				"masks": ["(242)###-####"],
			},
		},
		"BH": {
			"name": "Bahrain",
			"phone": {
				"code": "+973",
				"masks": ["####-####"],
			},
		},
		"BD": {
			"name": "Bangladesh",
			"phone": {
				"code": "+880",
				"masks": ["1###-######"],
			},
		},
		"BB": {
			"name": "Barbados",
			"phone": {
				"code": "+1",
				"masks": ["(246)###-####"],
			},
		},
		"BY": {
			"name": "Belarus",
			"phone": {
				"code": "+375",
				"masks": ["(##)###-##-##"],
			},
		},
		"BE": {
			"name": "Belgium",
			"phone": {
				"code": "+32",
				"masks": ["(###)###-###"],
			},
		},
		"BZ": {
			"name": "Belize",
			"phone": {
				"code": "+501",
				"masks": ["###-####"],
			},
		},
		"BJ": {
			"name": "Benin",
			"phone": {
				"code": "+229",
				"masks": ["##-##-####"],
			},
		},
		"BM": {
			"name": "Bermuda",
			"phone": {
				"code": "+1",
				"masks": ["(441)###-####"],
			},
		},
		"BT": {
			"name": "Bhutan",
			"phone": {
				"code": "+975",
				"masks": ["17-###-###", "77-###-###", "#-###-###"],
			},
		},
		"BO": {
			"name": "Bolivia",
			"phone": {
				"code": "+591",
				"masks": ["#-###-####"],
			},
		},
		"BA": {
			"name": "Bosnia and Herzegovina",
			"phone": {
				"code": "+387",
				"masks": ["##-####", "##-#####"],
			},
		},
		"BW": {
			"name": "Botswana",
			"phone": {
				"code": "+267",
				"masks": ["##-###-###"],
			},
		},
		"BR": {
			"name": "Brazil",
			"phone": {
				"code": "+55",
				"masks": ["(##)#####-####"],
			},
		},
		"IO": {
			"name": "British Indian Ocean Territory",
			"phone": {
				"code": "+246",
				"masks": ["###-####"],
			},
		},
		"BN": {
			"name": "Brunei Darussalam",
			"phone": {
				"code": "+673",
				"masks": ["###-####"],
			},
		},
		"BG": {
			"name": "Bulgaria",
			"phone": {
				"code": "+359",
				"masks": ["(###)###-###"],
			},
		},
		"BF": {
			"name": "Burkina Faso",
			"phone": {
				"code": "+226",
				"masks": ["##-##-####"],
			},
		},
		"BI": {
			"name": "Burundi",
			"phone": {
				"code": "+257",
				"masks": ["##-##-####"],
			},
		},
		"KH": {
			"name": "Cambodia",
			"phone": {
				"code": "+855",
				"masks": ["##-###-###"],
			},
		},
		"CM": {
			"name": "Cameroon",
			"phone": {
				"code": "+237",
				"masks": ["####-####"],
			},
		},
		"CA": {
			"name": "Canada",
			"phone": {
				"code": "+1",
				"masks": ["(###)###-####"],
			},
		},
		"CV": {
			"name": "Cape Verde",
			"phone": {
				"code": "+238",
				"masks": ["(###)##-##"],
			},
		},
		"KY": {
			"name": "Cayman Islands",
			"phone": {
				"code": "+1",
				"masks": ["(345)###-####"],
			},
		},
		"CF": {
			"name": "Central African Republic",
			"phone": {
				"code": "+236",
				"masks": ["##-##-####"],
			},
		},
		"TD": {
			"name": "Chad",
			"phone": {
				"code": "+235",
				"masks": ["##-##-##-##"],
			},
		},
		"CL": {
			"name": "Chile",
			"phone": {
				"code": "+56",
				"masks": ["#-####-####"],
			},
		},
		"CN": {
			"name": "China",
			"phone": {
				"code": "+86",
				"masks": ["(###)####-###", "(###)####-####", "##-#####-#####"],
			},
		},
		"CX": {
			"name": "Christmas Island",
			"phone": {
				"code": "+61",
				"masks": ["#-####-####"],
			},
		},
		"CC": {
			"name": "Cocos (Keeling) Islands",
			"phone": {
				"code": "+61",
				"masks": ["#-####-####"],
			},
		},
		"CO": {
			"name": "Colombia",
			"phone": {
				"code": "+57",
				"masks": ["(###)###-####"],
			},
		},
		"KM": {
			"name": "Comoros",
			"phone": {
				"code": "+269",
				"masks": ["##-#####"],
			},
		},
		"CG": {
			"name": "Congo",
			"phone": {
				"code": "+242",
				"masks": ["##-#####"],
			},
		},
		"CK": {
			"name": "Cook Islands",
			"phone": {
				"code": "+682",
				"masks": ["##-###"],
			},
		},
		"CR": {
			"name": "Costa Rica",
			"phone": {
				"code": "+506",
				"masks": ["####-####"],
			},
		},
		"HR": {
			"name": "Croatia",
			"phone": {
				"code": "+385",
				"masks": ["##-###-###"],
			},
		},
		"CU": {
			"name": "Cuba",
			"phone": {
				"code": "+53",
				"masks": ["#-###-####"],
			},
		},
		"CY": {
			"name": "Cyprus",
			"phone": {
				"code": "+357",
				"masks": ["##-###-###"],
			},
		},
		"CZ": {
			"name": "Czech Republic",
			"phone": {
				"code": "+420",
				"masks": ["(###)###-###"],
			},
		},
		"CD": {
			"name": "Democratic Republic of the Congo",
			"phone": {
				"code": "+243",
				"masks": ["(###)###-###"],
			},
		},
		"DK": {
			"name": "Denmark",
			"phone": {
				"code": "+45",
				"masks": ["##-##-##-##"],
			},
		},
		"DJ": {
			"name": "Djibouti",
			"phone": {
				"code": "+253",
				"masks": ["##-##-##-##"],
			},
		},
		"DM": {
			"name": "Dominica",
			"phone": {
				"code": "+1",
				"masks": ["(767)###-####"],
			},
		},
		"DO": {
			"name": "Dominican Republic",
			"phone": {
				"code": "+1",
				"masks": ["(809)###-####", "(829)###-####", "(849)###-####"],
			},
		},
		"EC": {
			"name": "Ecuador",
			"phone": {
				"code": "+593",
				"masks": ["#-###-####", "##-###-####"],
			},
		},
		"EG": {
			"name": "Egypt",
			"phone": {
				"code": "+20",
				"masks": ["(###)###-####"],
			},
		},
		"SV": {
			"name": "El Salvador",
			"phone": {
				"code": "+503",
				"masks": ["##-##-####"],
			},
		},
		"GQ": {
			"name": "Equatorial Guinea",
			"phone": {
				"code": "+240",
				"masks": ["##-###-####"],
			},
		},
		"ER": {
			"name": "Eritrea",
			"phone": {
				"code": "+291",
				"masks": ["#-###-###"],
			},
		},
		"EE": {
			"name": "Estonia",
			"phone": {
				"code": "+372",
				"masks": ["###-####", "####-####"],
			},
		},
		"SZ": {
			"name": "Eswatini",
			"phone": {
				"code": "+268",
				"masks": ["##-##-####"],
			},
		},
		"ET": {
			"name": "Ethiopia",
			"phone": {
				"code": "+251",
				"masks": ["##-###-####"],
			},
		},
		"FK": {
			"name": "Falkland Islands (Malvinas)",
			"phone": {
				"code": "+500",
				"masks": ["#####"],
			},
		},
		"FO": {
			"name": "Faroe Islands",
			"phone": {
				"code": "+298",
				"masks": ["###-###"],
			},
		},
		"FJ": {
			"name": "Fiji",
			"phone": {
				"code": "+679",
				"masks": ["##-#####"],
			},
		},
		"FI": {
			"name": "Finland",
			"phone": {
				"code": "+358",
				"masks": ["(###)###-##-##"],
			},
		},
		"FR": {
			"name": "France",
			"phone": {
				"code": "+33",
				"masks": ["(###)###-###"],
			},
		},
		"GF": {
			"name": "French Guiana",
			"phone": {
				"code": "+594",
				"masks": ["#####-####"],
			},
		},
		"PF": {
			"name": "French Polynesia",
			"phone": {
				"code": "+689",
				"masks": ["##-##-##"],
			},
		},
		"GA": {
			"name": "Gabon",
			"phone": {
				"code": "+241",
				"masks": ["#-##-##-##"],
			},
		},
		"GM": {
			"name": "Gambia",
			"phone": {
				"code": "+220",
				"masks": ["(###)##-##"],
			},
		},
		"GE": {
			"name": "Georgia",
			"phone": {
				"code": "+995",
				"masks": ["(###)###-###"],
			},
		},
		"DE": {
			"name": "Germany",
			"phone": {
				"code": "+49",
				"masks": ["###-###", "(###)##-##", "(###)##-###", "(###)##-####", "(###)###-####", "(####)###-####"],
			},
		},
		"GH": {
			"name": "Ghana",
			"phone": {
				"code": "+233",
				"masks": ["(###)###-###"],
			},
		},
		"GI": {
			"name": "Gibraltar",
			"phone": {
				"code": "+350",
				"masks": ["###-#####"],
			},
		},
		"GR": {
			"name": "Greece",
			"phone": {
				"code": "+30",
				"masks": ["(###)###-####"],
			},
		},
		"GL": {
			"name": "Greenland",
			"phone": {
				"code": "+299",
				"masks": ["##-##-##"],
			},
		},
		"GD": {
			"name": "Grenada",
			"phone": {
				"code": "+1",
				"masks": ["(473)###-####"],
			},
		},
		"GP": {
			"name": "Guadeloupe",
			"phone": {
				"code": "+590",
				"masks": ["(###)###-###"],
			},
		},
		"GU": {
			"name": "Guam",
			"phone": {
				"code": "+1",
				"masks": ["(671)###-####"],
			},
		},
		"GT": {
			"name": "Guatemala",
			"phone": {
				"code": "+502",
				"masks": ["#-###-####"],
			},
		},
		"GG": {
			"name": "Guernsey",
			"phone": {
				"code": "+44",
				"masks": ["(####)######"],
			},
		},
		"GN": {
			"name": "Guinea",
			"phone": {
				"code": "+224",
				"masks": ["##-###-###"],
			},
		},
		"GW": {
			"name": "Guinea-Bissau",
			"phone": {
				"code": "+245",
				"masks": ["#-######"],
			},
		},
		"GY": {
			"name": "Guyana",
			"phone": {
				"code": "+592",
				"masks": ["###-####"],
			},
		},
		"HT": {
			"name": "Haiti",
			"phone": {
				"code": "+509",
				"masks": ["##-##-####"],
			},
		},
		"VA": {
			"name": "Holy See (Vatican City State)",
			"phone": {
				"code": "+39",
				"masks": ["06 698#####"],
			},
		},
		"HN": {
			"name": "Honduras",
			"phone": {
				"code": "+504",
				"masks": ["####-####"],
			},
		},
		"HK": {
			"name": "Hong Kong",
			"phone": {
				"code": "+852",
				"masks": ["####-####"],
			},
		},
		"HU": {
			"name": "Hungary",
			"phone": {
				"code": "+36",
				"masks": ["(###)###-###"],
			},
		},
		"IS": {
			"name": "Iceland",
			"phone": {
				"code": "+354",
				"masks": ["###-####"],
			},
		},
		"IN": {
			"name": "India",
			"phone": {
				"code": "+91",
				"masks": ["(####)###-###"],
			},
		},
		"ID": {
			"name": "Indonesia",
			"phone": {
				"code": "+62",
				"masks": ["##-###-##", "##-###-###", "##-###-####", "(8##)###-###", "(8##)###-##-###"],
			},
		},
		"IR": {
			"name": "Iran",
			"phone": {
				"code": "+98",
				"masks": ["(###)###-####"],
			},
		},
		"IQ": {
			"name": "Iraq",
			"phone": {
				"code": "+924",
				"masks": ["(###)###-####"],
			},
		},
		"IE": {
			"name": "Ireland",
			"phone": {
				"code": "+353",
				"masks": ["(###)###-###"],
			},
		},
		"IM": {
			"name": "Isle of Man",
			"phone": {
				"code": "+44",
				"masks": ["(####)######"],
			},
		},
		"IL": {
			"name": "Israel",
			"phone": {
				"code": "+972",
				"masks": ["#-###-####", "5#-###-####"],
			},
		},
		"IT": {
			"name": "Italy",
			"phone": {
				"code": "+39",
				"masks": ["(###)####-###"],
			},
		},
		"CI": {
			"name": "Ivory Coast / Cote d'Ivoire",
			"phone": {
				"code": "+225",
				"masks": ["##-###-###"],
			},
		},
		"JM": {
			"name": "Jamaica",
			"phone": {
				"code": "+1",
				"masks": ["(876)###-####"],
			},
		},
		"JP": {
			"name": "Japan",
			"phone": {
				"code": "+81",
				"masks": ["(###)###-###", "##-####-####"],
			},
		},
		"JE": {
			"name": "Jersey",
			"phone": {
				"code": "+44",
				"masks": ["(####)####-######"],
			},
		},
		"JO": {
			"name": "Jordan",
			"phone": {
				"code": "+962",
				"masks": ["#-####-####"],
			},
		},
		"KZ": {
			"name": "Kazakhstan",
			"phone": {
				"code": "+77",
				"masks": ["(6##)###-##-##", "(7##)###-##-##"],
			},
		},
		"KE": {
			"name": "Kenya",
			"phone": {
				"code": "+254",
				"masks": ["###-######"],
			},
		},
		"KI": {
			"name": "Kiribati",
			"phone": {
				"code": "+686",
				"masks": ["##-###"],
			},
		},
		"KP": {
			"name": "Korea, Democratic People's Republic of Korea",
			"phone": {
				"code": "+850",
				"masks": ["###-###", "####-####", "##-###-###", "###-####-###", "191-###-####", "####-#############"],
			},
		},
		"KR": {
			"name": "Korea, Republic of South Korea",
			"phone": {
				"code": "+82",
				"masks": ["##-###-####"],
			},
		},
		"XK": {
			"name": "Kosovo",
			"phone": {
				"code": "+383",
				"masks": ["##-###-###", "###-###-###"],
			},
		},
		"KW": {
			"name": "Kuwait",
			"phone": {
				"code": "+965",
				"masks": ["####-####"],
			},
		},
		"KG": {
			"name": "Kyrgyzstan",
			"phone": {
				"code": "+996",
				"masks": ["(###)###-###"],
			},
		},
		"LA": {
			"name": "Laos",
			"phone": {
				"code": "+856",
				"masks": ["##-###-###", "(20##)###-###"],
			},
		},
		"LV": {
			"name": "Latvia",
			"phone": {
				"code": "+371",
				"masks": ["##-###-###"],
			},
		},
		"LB": {
			"name": "Lebanon",
			"phone": {
				"code": "+961",
				"masks": ["#-###-###", "##-###-###"],
			},
		},
		"LS": {
			"name": "Lesotho",
			"phone": {
				"code": "+266",
				"masks": ["#-###-####"],
			},
		},
		"LR": {
			"name": "Liberia",
			"phone": {
				"code": "+231",
				"masks": ["##-###-###"],
			},
		},
		"LY": {
			"name": "Libya",
			"phone": {
				"code": "+218",
				"masks": ["##-###-###", "21-###-####"],
			},
		},
		"LI": {
			"name": "Liechtenstein",
			"phone": {
				"code": "+423",
				"masks": ["(###)###-####"],
			},
		},
		"LT": {
			"name": "Lithuania",
			"phone": {
				"code": "+370",
				"masks": ["(###)##-###"],
			},
		},
		"LU": {
			"name": "Luxembourg",
			"phone": {
				"code": "+352",
				"masks": ["(###)###-###"],
			},
		},
		"MO": {
			"name": "Macau",
			"phone": {
				"code": "+853",
				"masks": ["####-####"],
			},
		},
		"MG": {
			"name": "Madagascar",
			"phone": {
				"code": "+261",
				"masks": ["##-##-#####"],
			},
		},
		"MW": {
			"name": "Malawi",
			"phone": {
				"code": "+265",
				"masks": ["1-###-###", "#-####-####"],
			},
		},
		"MY": {
			"name": "Malaysia",
			"phone": {
				"code": "+60",
				"masks": ["#-###-###", "##-###-###", "(###)###-###", "##-###-####"],
			},
		},
		"MV": {
			"name": "Maldives",
			"phone": {
				"code": "+960",
				"masks": ["###-####"],
			},
		},
		"ML": {
			"name": "Mali",
			"phone": {
				"code": "+223",
				"masks": ["##-##-####"],
			},
		},
		"MT": {
			"name": "Malta",
			"phone": {
				"code": "+356",
				"masks": ["####-####"],
			},
		},
		"MH": {
			"name": "Marshall Islands",
			"phone": {
				"code": "+692",
				"masks": ["###-####"],
			},
		},
		"MQ": {
			"name": "Martinique",
			"phone": {
				"code": "+596",
				"masks": ["(###)##-##-##"],
			},
		},
		"MR": {
			"name": "Mauritania",
			"phone": {
				"code": "+222",
				"masks": ["##-##-####"],
			},
		},
		"MU": {
			"name": "Mauritius",
			"phone": {
				"code": "+230",
				"masks": ["###-####"],
			},
		},
		"YT": {
			"name": "Mayotte",
			"phone": {
				"code": "+262",
				"masks": ["#####-####"],
			},
		},
		"MX": {
			"name": "Mexico",
			"phone": {
				"code": "+52",
				"masks": ["##-##-####", "(###)###-####"],
			},
		},
		"FM": {
			"name": "Micronesia, Federated States of Micronesia",
			"phone": {
				"code": "+691",
				"masks": ["###-####"],
			},
		},
		"MD": {
			"name": "Moldova",
			"phone": {
				"code": "+373",
				"masks": ["####-####"],
			},
		},
		"MC": {
			"name": "Monaco",
			"phone": {
				"code": "+377",
				"masks": ["##-###-###", "(###)###-###"],
			},
		},
		"MN": {
			"name": "Mongolia",
			"phone": {
				"code": "+976",
				"masks": ["##-##-####"],
			},
		},
		"ME": {
			"name": "Montenegro",
			"phone": {
				"code": "+382",
				"masks": ["##-###-###"],
			},
		},
		"MS": {
			"name": "Montserrat",
			"phone": {
				"code": "+1",
				"masks": ["(664)###-####"],
			},
		},
		"MA": {
			"name": "Morocco",
			"phone": {
				"code": "+212",
				"masks": ["##-####-###"],
			},
		},
		"MZ": {
			"name": "Mozambique",
			"phone": {
				"code": "+258",
				"masks": ["##-###-###"],
			},
		},
		"MM": {
			"name": "Myanmar",
			"phone": {
				"code": "+95",
				"masks": ["###-###", "#-###-###", "##-###-###"],
			},
		},
		"NA": {
			"name": "Namibia",
			"phone": {
				"code": "+224",
				"masks": ["##-###-####"],
			},
		},
		"NR": {
			"name": "Nauru",
			"phone": {
				"code": "+674",
				"masks": ["###-####"],
			},
		},
		"NP": {
			"name": "Nepal",
			"phone": {
				"code": "+977",
				"masks": ["##-###-###"],
			},
		},
		"NL": {
			"name": "Netherlands",
			"phone": {
				"code": "+31",
				"masks": ["##-###-####"],
			},
		},
		"AN": {
			"name": "Netherlands Antilles",
			"phone": {
				"code": "+599",
				"masks": ["###-####", "9###-####"],
			},
		},
		"NC": {
			"name": "New Caledonia",
			"phone": {
				"code": "+687",
				"masks": ["##-####"],
			},
		},
		"NZ": {
			"name": "New Zealand",
			"phone": {
				"code": "+24",
				"masks": ["#-###-###", "(###)###-###", "(###)###-####"],
			},
		},
		"NI": {
			"name": "Nicaragua",
			"phone": {
				"code": "+505",
				"masks": ["####-####"],
			},
		},
		"NE": {
			"name": "Niger",
			"phone": {
				"code": "+227",
				"masks": ["##-##-####"],
			},
		},
		"NG": {
			"name": "Nigeria",
			"phone": {
				"code": "+234",
				"masks": ["##-###-##", "##-###-###", "(###)###-####"],
			},
		},
		"NU": {
			"name": "Niue",
			"phone": {
				"code": "+683",
				"masks": ["####"],
			},
		},
		"NF": {
			"name": "Norfolk Island",
			"phone": {
				"code": "+672",
				"masks": ["3##-###"],
			},
		},
		"MK": {
			"name": "North Macedonia",
			"phone": {
				"code": "+389",
				"masks": ["##-###-###"],
			},
		},
		"MP": {
			"name": "Northern Mariana Islands",
			"phone": {
				"code": "+1",
				"masks": ["(670)###-####"],
			},
		},
		"NO": {
			"name": "Norway",
			"phone": {
				"code": "+47",
				"masks": ["(###)##-###"],
			},
		},
		"OM": {
			"name": "Oman",
			"phone": {
				"code": "+968",
				"masks": ["##-###-###"],
			},
		},
		"PK": {
			"name": "Pakistan",
			"phone": {
				"code": "+92",
				"masks": ["(###)###-####"],
			},
		},
		"PW": {
			"name": "Palau",
			"phone": {
				"code": "+680",
				"masks": ["###-####"],
			},
		},
		"PS": {
			"name": "Palestine",
			"phone": {
				"code": "+970",
				"masks": ["##-###-####"],
			},
		},
		"PA": {
			"name": "Panama",
			"phone": {
				"code": "+507",
				"masks": ["###-####"],
			},
		},
		"PG": {
			"name": "Papua New Guinea",
			"phone": {
				"code": "+675",
				"masks": ["(###)##-###"],
			},
		},
		"PY": {
			"name": "Paraguay",
			"phone": {
				"code": "+595",
				"masks": ["(###)###-###"],
			},
		},
		"PE": {
			"name": "Peru",
			"phone": {
				"code": "+51",
				"masks": ["(###)###-###"],
			},
		},
		"PH": {
			"name": "Philippines",
			"phone": {
				"code": "+63",
				"masks": ["(###)###-####"],
			},
		},
		"PN": {
			"name": "Pitcairn",
			"phone": {
				"code": "+870",
				"masks": ["###-###-###"],
			},
		},
		"PL": {
			"name": "Poland",
			"phone": {
				"code": "+48",
				"masks": ["(###)###-###"],
			},
		},
		"PT": {
			"name": "Portugal",
			"phone": {
				"code": "+351",
				"masks": ["##-###-####"],
			},
		},
		"PR": {
			"name": "Puerto Rico",
			"phone": {
				"code": "+1",
				"masks": ["(787) ### ####", "(939) ### ####"],
			},
		},
		"QA": {
			"name": "Qatar",
			"phone": {
				"code": "+974",
				"masks": ["####-####"],
			},
		},
		"RE": {
			"name": "Reunion",
			"phone": {
				"code": "+262",
				"masks": ["#####-####"],
			},
		},
		"RO": {
			"name": "Romania",
			"phone": {
				"code": "+40",
				"masks": ["##-###-####"],
			},
		},
		"RU": {
			"name": "Russia",
			"phone": {
				"code": "+7",
				"masks": ["(###)###-##-##"],
			},
		},
		"RW": {
			"name": "Rwanda",
			"phone": {
				"code": "+250",
				"masks": ["(###)###-###"],
			},
		},
		"BL": {
			"name": "Saint Barthelemy",
			"phone": {
				"code": "+590",
				"masks": ["###-##-##-##"],
			},
		},
		"SH": {
			"name": "Saint Helena, Ascension and Tristan Da Cunha",
			"phone": {
				"code": "+290",
				"masks": ["####"],
			},
		},
		"KN": {
			"name": "Saint Kitts and Nevis",
			"phone": {
				"code": "+1",
				"masks": ["(869)###-####"],
			},
		},
		"LC": {
			"name": "Saint Lucia",
			"phone": {
				"code": "+1",
				"masks": ["(758)###-####"],
			},
		},
		"MF": {
			"name": "Saint Martin",
			"phone": {
				"code": "+590",
				"masks": ["(###)###-###"],
			},
		},
		"PM": {
			"name": "Saint Pierre and Miquelon",
			"phone": {
				"code": "+508",
				"masks": ["##-####"],
			},
		},
		"VC": {
			"name": "Saint Vincent and the Grenadines",
			"phone": {
				"code": "+1",
				"masks": ["(784)###-####"],
			},
		},
		"WS": {
			"name": "Samoa",
			"phone": {
				"code": "+685",
				"masks": ["##-####"],
			},
		},
		"SM": {
			"name": "San Marino",
			"phone": {
				"code": "+378",
				"masks": ["####-######"],
			},
		},
		"ST": {
			"name": "Sao Tome and Principe",
			"phone": {
				"code": "+239",
				"masks": ["##-#####"],
			},
		},
		"SA": {
			"name": "Saudi Arabia",
			"phone": {
				"code": "+966",
				"masks": ["#-###-####", "5#-####-####"],
			},
		},
		"SN": {
			"name": "Senegal",
			"phone": {
				"code": "+221",
				"masks": ["##-###-####"],
			},
		},
		"RS": {
			"name": "Serbia",
			"phone": {
				"code": "+381",
				"masks": ["##-###-####"],
			},
		},
		"SC": {
			"name": "Seychelles",
			"phone": {
				"code": "+248",
				"masks": ["#-###-###"],
			},
		},
		"SL": {
			"name": "Sierra Leone",
			"phone": {
				"code": "+232",
				"masks": ["##-######"],
			},
		},
		"SG": {
			"name": "Singapore",
			"phone": {
				"code": "+65",
				"masks": ["####-####"],
			},
		},
		"SX": {
			"name": "Sint Maarten",
			"phone": {
				"code": "+1",
				"masks": ["(721)###-####"],
			},
		},
		"SK": {
			"name": "Slovakia",
			"phone": {
				"code": "+421",
				"masks": ["(###)###-###"],
			},
		},
		"SI": {
			"name": "Slovenia",
			"phone": {
				"code": "+386",
				"masks": ["##-###-###"],
			},
		},
		"SB": {
			"name": "Solomon Islands",
			"phone": {
				"code": "+677",
				"masks": ["#####", "###-####"],
			},
		},
		"SO": {
			"name": "Somalia",
			"phone": {
				"code": "+252",
				"masks": ["#-###-###", "##-###-###"],
			},
		},
		"ZA": {
			"name": "South Africa",
			"phone": {
				"code": "+27",
				"masks": ["##-###-####"],
			},
		},
		"GS": {
			"name": "South Georgia and the South Sandwich Islands",
			"phone": {
				"code": "+500",
				"masks": ["#####"],
			},
		},
		"SS": {
			"name": "South Sudan",
			"phone": {
				"code": "+211",
				"masks": ["##-###-####"],
			},
		},
		"ES": {
			"name": "Spain",
			"phone": {
				"code": "+34",
				"masks": ["(###)###-###"],
			},
		},
		"LK": {
			"name": "Sri Lanka",
			"phone": {
				"code": "+94",
				"masks": ["##-###-####"],
			},
		},
		"SD": {
			"name": "Sudan",
			"phone": {
				"code": "+249",
				"masks": ["##-###-####"],
			},
		},
		"SR": {
			"name": "Suriname",
			"phone": {
				"code": "+597",
				"masks": ["###-###", "###-####"],
			},
		},
		"SJ": {
			"name": "Svalbard and Jan Mayen",
			"phone": {
				"code": "+47",
				"masks": ["(###)##-###"],
			},
		},
		"SE": {
			"name": "Sweden",
			"phone": {
				"code": "+46",
				"masks": ["##-###-####"],
			},
		},
		"CH": {
			"name": "Switzerland",
			"phone": {
				"code": "+41",
				"masks": ["##-###-####"],
			},
		},
		"SY": {
			"name": "Syrian Arab Republic",
			"phone": {
				"code": "+963",
				"masks": ["##-####-###"],
			},
		},
		"TW": {
			"name": "Taiwan",
			"phone": {
				"code": "+886",
				"masks": ["####-####", "#-####-####"],
			},
		},
		"TJ": {
			"name": "Tajikistan",
			"phone": {
				"code": "+992",
				"masks": ["##-###-####"],
			},
		},
		"TZ": {
			"name": "Tanzania, United Republic of Tanzania",
			"phone": {
				"code": "+255",
				"masks": ["##-###-####"],
			},
		},
		"TH": {
			"name": "Thailand",
			"phone": {
				"code": "+66",
				"masks": ["##-###-###", "##-###-####"],
			},
		},
		"TL": {
			"name": "Timor-Leste",
			"phone": {
				"code": "+670",
				"masks": ["###-####", "77#-#####", "78#-#####"],
			},
		},
		"TG": {
			"name": "Togo",
			"phone": {
				"code": "+228",
				"masks": ["##-###-###"],
			},
		},
		"TK": {
			"name": "Tokelau",
			"phone": {
				"code": "+690",
				"masks": ["####"],
			},
		},
		"TO": {
			"name": "Tonga",
			"phone": {
				"code": "+676",
				"masks": ["#####"],
			},
		},
		"TT": {
			"name": "Trinidad and Tobago",
			"phone": {
				"code": "+1",
				"masks": ["(868)###-####"],
			},
		},
		"TN": {
			"name": "Tunisia",
			"phone": {
				"code": "+216",
				"masks": ["##-###-###"],
			},
		},
		"TR": {
			"name": "Turkey",
			"phone": {
				"code": "+90",
				"masks": ["(###)###-####"],
			},
		},
		"TM": {
			"name": "Turkmenistan",
			"phone": {
				"code": "+993",
				"masks": ["#-###-####"],
			},
		},
		"TC": {
			"name": "Turks and Caicos Islands",
			"phone": {
				"code": "+1",
				"masks": ["(249)###-###"],
			},
		},
		"TV": {
			"name": "Tuvalu",
			"phone": {
				"code": "+688",
				"masks": ["2####", "90####"],
			},
		},
		"UG": {
			"name": "Uganda",
			"phone": {
				"code": "+256",
				"masks": ["(###)###-###"],
			},
		},
		"UA": {
			"name": "Ukraine",
			"phone": {
				"code": "+380",
				"masks": ["(##)###-##-##"],
			},
		},
		"AE": {
			"name": "United Arab Emirates",
			"phone": {
				"code": "+971",
				"masks": ["#-###-####", "5#-###-####"],
			},
		},
		"GB": {
			"name": "United Kingdom",
			"phone": {
				"code": "+44",
				"masks": ["##-####-####"],
			},
		},
		"US": {
			"name": "United States",
			"phone": {
				"code": "+1",
				"masks": ["(###)###-####"],
			},
		},
		"UY": {
			"name": "Uruguay",
			"phone": {
				"code": "+598",
				"masks": ["#-###-##-##"],
			},
		},
		"UZ": {
			"name": "Uzbekistan",
			"phone": {
				"code": "+998",
				"masks": ["##-###-####"],
			},
		},
		"VU": {
			"name": "Vanuatu",
			"phone": {
				"code": "+678",
				"masks": ["#####", "##-#####"],
			},
		},
		"VE": {
			"name": "Venezuela, Bolivarian Republic of Venezuela",
			"phone": {
				"code": "+58",
				"masks": ["(###)###-####"],
			},
		},
		"VN": {
			"name": "Vietnam",
			"phone": {
				"code": "+84",
				"masks": ["##-####-###", "(###)####-###"],
			},
		},
		"VG": {
			"name": "Virgin Islands, British",
			"phone": {
				"code": "+1",
				"masks": ["(284)###-####"],
			},
		},
		"VI": {
			"name": "Virgin Islands, U.S.",
			"phone": {
				"code": "+1",
				"masks": ["(340)###-####"],
			},
		},
		"WF": {
			"name": "Wallis and Futuna",
			"phone": {
				"code": "+681",
				"masks": ["##-####"],
			},
		},
		"YE": {
			"name": "Yemen",
			"phone": {
				"code": "+967",
				"masks": ["#-###-###", "##-###-###", "###-###-###"],
			},
		},
		"ZM": {
			"name": "Zambia",
			"phone": {
				"code": "+260",
				"masks": ["##-###-####"],
			},
		},
		"ZW": {
			"name": "Zimbabwe",
			"phone": {
				"code": "+263",
				"masks": ["#-######"],
			},
		}
	};
	
	if (id !== null) {
		if (data[id]) {
			return data[id];
		}

		return Object.values(data)
			.filter(item => {
				return item.phone.code === id || item.phone.code === `+${id}`;
			})
			.at(0) || false;
	}

	return data;
};

window.countryMetas = countryMetas;
