const useCalendarStore = Pinia.defineStore({
	id: "calendar",
	state: () => ({ seasonsPropertyMonth: {} }),
	actions: {
		async getSeasonsByPropertyByMonth(payload) {
			const propertiesStore = window.usePropertiesStore();

			const criteria = [
				{
					field: "published",
					value: 1,
					condition_type: "eq",
					condition: "where",
				},
				{
					field: "start_date",
					value: payload.start_date_from,
					condition_type: "gteq",
					condition: "where",
				},
				{
					field: "start_date",
					value: payload.start_date_end,
					condition_type: "lteq",
					condition: "where",
				},
			];
			const result = await propertiesStore.getPropertySeasons({
				id: payload.id,
				per_page: payload.per_page || 31,
				page: payload.page || 1,
				criteria: window.serialize({ filters: criteria }),
			});

			const season_key = window
				.$moment(payload.start_date_from)
				.format("MM/YYYY");

			// Verifica se o objeto `seasonsPropertyMonth` já tem a chave `payload.id`
			if (!this.seasonsPropertyMonth[payload.id]) {
				this.seasonsPropertyMonth[payload.id] = {};
			}

			// Verifica se o mês já existe; se sim, concatena os novos resultados
			if (!this.seasonsPropertyMonth[payload.id][season_key]) {
				this.seasonsPropertyMonth[payload.id][season_key] =
					result.data.data.entities;
			} else {
				this.seasonsPropertyMonth[payload.id][season_key] = [
					...this.seasonsPropertyMonth[payload.id][season_key],
					...result.data.data.entities,
				];
			}
		},
	},
	getters: {},
});
window.useCalendarStore = useCalendarStore;
