const usePropertiesStore = Pinia.defineStore({
	id: "properties",
	state: () => ({
		// properties: [],
		property: {},
		bannerImages: [],
		loading: false,
	}),
	persist: true,
	storage: localStorage,
	actions: {
		async setProperties() {
			try {
				this.loading = true;
				const listProperties = await axios.get(
					"/properties/wordpress/search",
				);
				const properties = listProperties.data.data.entities;

				const url = `${properties[0].properties.id}/${properties[0].properties.slug}`;
				// const url = "6615/hat-head-copy-2324";
				const showProperty = await axios.get(
					`/guest/properties/${url}`,
				);
				this.property = showProperty.data.data;
			} catch (e) {
				console.error(e);
			} finally {
				this.loading = false;
			}
		},
		setBannerImages(images) {
			this.bannerImages = images;
		},
		setLoading(loading) {
			this.loading = loading;
		},
		async getPropertySeasons(payload) {
			let result;
			const params = {
				page: payload.page || 1,
				per_page: payload.per_page || 31,
			};

			let url = `/guest/property/${payload.id}/seasons`;

			if (payload.criteria) {
				url += `?${payload.criteria}`;
			}

			try {
				result = await axios.get(url, {
					params: params,
					withCredentials: true,
				});
			} catch (e) {
				return { success: false, e };
			}

			return result;
		},
	},
	getters: {
		// getProperties: (state) => state.properties,
		getPropertyVendor: (state) => state.property ?? {},
		getLoading: (state) => state.loading,
		getBannerImages: (state) => state.bannerImages,
	},
});

window.usePropertiesStore = usePropertiesStore;
