// Array

// https://day.js.org/docs/en/display/format
const dateFormat = (date, format = "DD/MM/YYYY") => {
	const d = window.$moment(date || undefined);
	if (!d.isValid()) return "";
	return d.format(format);
};

const datetimeFormat = (date, format = "DD/MM/YYYY ~ HH:mm") => {
	const d = window.$moment(date || undefined);
	if (!d.isValid()) return "";
	return d.format(format);
};

// Number
const money = (number, currency) => {
	//const f = new Intl.NumberFormat('en-AU', {style: 'currency', currency: currency ?? 'AUD'});
	//return `${currency ?? 'AUD'}${f.format(parseFloat(number))}`;
	//return f.format(parseFloat(number));
	return `${currency ?? "AUD"} ${parseFloat(number).toLocaleString("en-AU", {
		minimumFractionDigits: 2,
		maximumFractionDigits: 2,
	})}`;
};

const numberCounter = (number) => {
	return Intl.NumberFormat("en", {
		notation: "compact",
		minimumFractionDigits: "0",
	}).format(number);
};

// Object

// String
const stringPlural = (number, singular, plural) => {
	return number == 1 ? singular : plural;
};

// ex: string_test to String test
const textify = (text) => {
	return capitalize((text || "").split(/[^a-zA-Z0-9]/g).join(" "));
};

window.dateFormat = dateFormat;
window.datetimeFormat = datetimeFormat;
window.money = money;
window.numberCounter = numberCounter;
window.stringPlural = stringPlural;
window.textify = textify;
