<?php

//* Add custom sections to the Wordpress Customizer
class Sas_Customizer{
    public function __construct() {
        add_action('customize_register', array($this, 'register_customize_sections'));
    }

    public function register_customize_sections ($wp_customize){
        // Call section
        $this->social_links($wp_customize);
        $this->footer_logo($wp_customize);
    }

    //Social Links
    private function social_links($wp_customize){

        //Section Panel
        $wp_customize->add_section('social-links', array(
            'title' => 'Social Links',
            'priority' => 5,
            'description' => __('In this section you will be able to manage your social links.', 'sastheme'),
        ));

        //Twitter
        $wp_customize->add_setting('twitter-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'twitter-social-link', array(
            'label' => 'X (Twitter)',
            'section' => 'social-links',
            'settings' => 'twitter-social',
            'type' => 'text'
        )));

        //Facebook
        $wp_customize->add_setting('facebook-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'facebook-social-link', array(
            'label' => 'Facebook',
            'section' => 'social-links',
            'settings' => 'facebook-social',
            'type' => 'text'
        )));

        //Google+
        $wp_customize->add_setting('google-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'google-social-link', array(
            'label' => 'Google+',
            'section' => 'social-links',
            'settings' => 'google-social',
            'type' => 'text'
        )));

        //Instagram
        $wp_customize->add_setting('instagram-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'instagram-social-link', array(
            'label' => 'Instagram',
            'section' => 'social-links',
            'settings' => 'instagram-social',
            'type' => 'text'
        )));
    }

    //Footer Logo
    private function footer_logo($wp_customize){
        
        $wp_customize->add_setting('custom-footer-logo', array(
            'default' => '',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array($this, 'sanitize_custom_url'),
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer-logo', array(
            'label' => 'Footer Logo',
            'section' => 'title_tagline',
            'settings' => 'custom-footer-logo'   
        )));
    }

    //Sanitize Functions
    public function sanitize_custom_option($input) {
        return ($input === 'No') ? 'No' : 'Yes';
    }

    public function sanitize_custom_url($input) {
        return filter_var($input, FILTER_SANITIZE_URL);
    }

    public function sanitize_custom_text($input) {
        return filter_var($input, FILTER_SANITIZE_STRING);
    }
}