<?php

//* Theme Required Pages
class Sas_Required_Pages {

	public function __construct() {
		add_action( 'after_switch_theme', array($this, 'create_theme_pages' ));
	}

	public function create_theme_pages() {

		
		$home = array(
			'post_type'		=> 'page',
			'post_title'	=> 'Home',
			'post_content'	=> '',
			'post_status'	=> 'publish',
			'post_author'	=> 1,
			'post_name'		=> 'home',
			'page_template'	=> 'templates/home.php'
		);
		$blog = array(
			'post_type'		=> 'page',
			'post_title'	=> 'Blog',
			'post_content'	=> '',
			'post_status'	=> 'publish',
			'post_author'	=> 1,
			'post_name'		=> 'blog',
		);

		if (!get_page_by_path('home', OBJECT, 'page')) {
			$home_id = wp_insert_post($home);
			update_option( 'page_on_front', $home_id );
			update_option( 'show_on_front', 'page' );
		}
		if (!get_page_by_path('blog', OBJECT, 'page')) {
			$blog_id = wp_insert_post($blog);
			update_option( 'page_for_posts', $blog_id );
		}
	}
}