<?php get_header() ?>

<section class="sas-row blog-single">
    <?php if (have_posts()): ?>
        <?php while (have_posts()): ?>
            <?php the_post();

                $has_viewport = true;

                $ne_lat = get_post_meta(get_the_ID(), 'ne_lat');
                $ne_lng = get_post_meta(get_the_ID(), 'ne_lng');
                $sw_lat = get_post_meta(get_the_ID(), 'sw_lat');
                $sw_lng = get_post_meta(get_the_ID(), 'sw_lng');

                $ne_lat = (is_array($ne_lat) && isset($ne_lat[0]))? $ne_lat[0] : $ne_lat;
                $ne_lng = (is_array($ne_lng) && isset($ne_lng[0]))? $ne_lng[0] : $ne_lng;
                $sw_lat = (is_array($sw_lat) && isset($sw_lat[0]))? $sw_lat[0] : $sw_lat;
                $sw_lng = (is_array($sw_lng) && isset($sw_lng[0]))? $sw_lng[0] : $sw_lng;

                if(!$ne_lat || !$ne_lng || !$sw_lat || !$sw_lng) {
                    $has_viewport = false;
                }
        
            ?>
            <div class="post-thumb">
                <?php
                if (!has_post_thumbnail()) {
                    echo "<img src='" . get_template_directory_uri() . "/assets/images/1920x795.png' />";
                } else {
                    the_post_thumbnail();
                }
                ?>
            </div>

            <article class="container post-content">
                <header>
                    <h3 class="sas-title">
                        <?php the_title(); ?>
                    </h3>
                </header>
                <div>
                    <?php the_content(); ?>
                </div>
            </article>

            <?php comments_template(); ?>
    
            <?php if($has_viewport): ?>
                <div class="px-2 py-4 bg-white">

                    <h2 class="pb-4 text-center">
                        Properties
                    </h2>
                    <?php echo do_shortcode('[property_list_view_port '.$ne_lat.', '.$ne_lng.', '.$sw_lat.', '.$sw_lng.']'); ?>

                </div>
            <?php endif ?>
    
        <?php endwhile; ?>
    <?php endif ?>
</section>

<?php get_footer() ?>