<?php
/**
 * Displays the site header.
 */

$wrapper_classes  = 'site-header';
$wrapper_classes .= has_custom_logo() ? ' has-logo' : '';
$wrapper_classes .= ( true === get_theme_mod( 'display_title_and_tagline', true ) ) ? ' has-title-and-tagline' : '';
$wrapper_classes .= has_nav_menu( 'main' ) ? ' has-menu' : '';
?>
<header class="<?php echo esc_attr( $wrapper_classes ); ?>">
	<div class="container">
		<?php get_template_part( 'template-parts/header/site-branding' ); ?>
		<div class="d-flex main-nav">
			<div>
				<?php get_template_part( 'template-parts/header/main-nav' ); ?>
			</div>
		</div>
	</div>

	<div class="mobile-overlay"></div>
</header>
